# -*- coding: utf-8 -*-
# Part of Odoo. See LICENSE file for full copyright and licensing details.

# Built from: https://ecdf-developer.b2g.etat.lu/ecdf/formdocs/2019/CA_PLANCOMPTA/2019M1V003/CA_PLANCOMPTA_LINK_00_DOC_EN_2019M1V003.fieldlist
# The dictionary keys represent the first N digits (with N the lenghts of the code) of the accounts matching the category.
# The dictionary values are themselves a dictionary indicating in which declaration field the debit of the matching accounts
# should be reported ("debit" key), and in which one the credits should be reported ("credit key").
# Based on the LU 2019 Chart of Accounts.
ACCOUNTS_2019 = {
    "10": {"debit": "0101", "credit": "0102"}, "101": {"debit": "0103", "credit": "0104"}, "102": {"debit": "0105", "credit": "0106"},
    "103": {"debit": "0107", "credit": "0108"}, "104": {"debit": "0109", "credit": "0110"}, "1041": {"debit": "0111", "credit": "0112"},
    "1042": {"debit": "0113", "credit": "0114"}, "105": {"debit": "0115", "credit": "0116"}, "106": {"debit": "0117", "credit": "0118"},
    "11": {"debit": "0119", "credit": "0120"}, "111": {"debit": "0121", "credit": "0122"}, "112": {"debit": "0123", "credit": "0124"},
    "113": {"debit": "0125", "credit": "0126"}, "114": {"debit": "0127", "credit": "0128"}, "115": {"debit": "0129", "credit": "0130"},
    "12": {"debit": "0131", "credit": "0132"}, "121": {"debit": "0133", "credit": "0134"}, "122": {"debit": "0135", "credit": "0136"},
    "123": {"debit": "0137", "credit": "0138"}, "128": {"debit": "0139", "credit": "0140"}, "13": {"debit": "0141", "credit": "0142"},
    "131": {"debit": "0143", "credit": "0144"}, "132": {"debit": "0145", "credit": "0146"}, "133": {"debit": "0147", "credit": "0148"},
    "138": {"debit": "0149", "credit": "0150"}, "1381": {"debit": "0151", "credit": "0152"}, "1382": {"debit": "0153", "credit": "0154"},
    "1383": {"debit": "0155", "credit": "0156"}, "14": {"debit": "0157", "credit": "0158"}, "141": {"debit": "0159", "credit": "0160"},
    "142": {"debit": "0161", "credit": "0162"}, "15": {"debit": "0163", "credit": "0164"}, "16": {"debit": "0165", "credit": "0166"},
    "161": {"debit": "0167", "credit": "0168"}, "162": {"debit": "0169", "credit": "0170"}, "163": {"debit": "0171", "credit": "0172"},
    "168": {"debit": "0173", "credit": "0174"}, "17": {"debit": "0175", "credit": "0176"}, "171": {"debit": "0177", "credit": "0178"},
    "172": {"debit": "0179", "credit": "0180"}, "18": {"debit": "0181", "credit": "0182"}, "181": {"debit": "0183", "credit": "0184"},
    "182": {"debit": "0185", "credit": "0186"}, "1821": {"debit": "0187", "credit": "0188"}, "1822": {"debit": "0189", "credit": "0190"},
    "1823": {"debit": "0191", "credit": "0192"}, "1828": {"debit": "0193", "credit": "0194"}, "183": {"debit": "0195", "credit": "0196"},
    "188": {"debit": "0197", "credit": "0198"}, "1881": {"debit": "0199", "credit": "0200"}, "1882": {"debit": "0201", "credit": "0202"},
    "1883": {"debit": "0203", "credit": "0204"}, "19": {"debit": "0205", "credit": "0206"}, "191": {"debit": "0207", "credit": "0208"},
    "1911": {"debit": "0209", "credit": "0210"}, "19111": {"debit": "0211", "credit": "0212"}, "19112": {"debit": "0213", "credit": "0214"},
    "1912": {"debit": "0215", "credit": "0216"}, "19121": {"debit": "0217", "credit": "0218"}, "19122": {"debit": "0219", "credit": "0220"},
    "192": {"debit": "0221", "credit": "0222"}, "1921": {"debit": "0223", "credit": "0224"}, "19211": {"debit": "0225", "credit": "0226"},
    "19212": {"debit": "0227", "credit": "0228"}, "1922": {"debit": "0229", "credit": "0230"}, "19221": {"debit": "0231", "credit": "0232"},
    "19222": {"debit": "0233", "credit": "0234"}, "193": {"debit": "0235", "credit": "0236"}, "1931": {"debit": "0237", "credit": "0238"},
    "19311": {"debit": "0239", "credit": "0240"}, "19312": {"debit": "0241", "credit": "0242"}, "1932": {"debit": "0243", "credit": "0244"},
    "19321": {"debit": "0245", "credit": "0246"}, "19322": {"debit": "0247", "credit": "0248"}, "194": {"debit": "0249", "credit": "0250"},
    "1941": {"debit": "0251", "credit": "0252"}, "19411": {"debit": "0253", "credit": "0254"}, "19412": {"debit": "0255", "credit": "0256"},
    "1942": {"debit": "0257", "credit": "0258"}, "19421": {"debit": "0259", "credit": "0260"}, "19422": {"debit": "0261", "credit": "0262"},
    "195": {"debit": "0263", "credit": "0264"}, "1951": {"debit": "0265", "credit": "0266"}, "1952": {"debit": "0267", "credit": "0268"},
    "198": {"debit": "0269", "credit": "0270"}, "1981": {"debit": "0271", "credit": "0272"}, "19811": {"debit": "0273", "credit": "0274"},
    "19812": {"debit": "0275", "credit": "0276"}, "19813": {"debit": "0277", "credit": "0278"}, "19814": {"debit": "0279", "credit": "0280"},
    "1982": {"debit": "0281", "credit": "0282"}, "19821": {"debit": "0283", "credit": "0284"}, "19822": {"debit": "0285", "credit": "0286"},
    "19823": {"debit": "0287", "credit": "0288"}, "19824": {"debit": "0289", "credit": "0290"}, "20": {"debit": "0291", "credit": "0292"},
    "201": {"debit": "0293", "credit": "0294"}, "202": {"debit": "0295", "credit": "0296"}, "2021": {"debit": "0297", "credit": "0298"},
    "2022": {"debit": "0299", "credit": "0300"}, "203": {"debit": "0301", "credit": "0302"}, "204": {"debit": "0303", "credit": "0304"},
    "208": {"debit": "0305", "credit": "0306"}, "21": {"debit": "0307", "credit": "0308"}, "211": {"debit": "0309", "credit": "0310"},
    "212": {"debit": "0311", "credit": "0312"}, "2121": {"debit": "0313", "credit": "0314"}, "21211": {"debit": "0315", "credit": "0316"},
    "21212": {"debit": "0317", "credit": "0318"}, "21213": {"debit": "0319", "credit": "0320"}, "21214": {"debit": "0321", "credit": "0322"},
    "21215": {"debit": "0323", "credit": "0324"}, "212151": {"debit": "0325", "credit": "0326"}, "212152": {"debit": "0327", "credit": "0328"},
    "212158": {"debit": "0329", "credit": "0330"}, "2122": {"debit": "0331", "credit": "0332"}, "21221": {"debit": "0333", "credit": "0334"},
    "21222": {"debit": "0335", "credit": "0336"}, "21223": {"debit": "0337", "credit": "0338"}, "21224": {"debit": "0339", "credit": "0340"},
    "21225": {"debit": "0341", "credit": "0342"}, "212251": {"debit": "0343", "credit": "0344"}, "212252": {"debit": "0345", "credit": "0346"},
    "212258": {"debit": "0347", "credit": "0348"}, "213": {"debit": "0349", "credit": "0350"}, "214": {"debit": "0351", "credit": "0352"},
    "2141": {"debit": "0353", "credit": "0354"}, "2142": {"debit": "0355", "credit": "0356"}, "2143": {"debit": "0357", "credit": "0358"},
    "22": {"debit": "0359", "credit": "0360"}, "221": {"debit": "0361", "credit": "0362"}, "2211": {"debit": "0363", "credit": "0364"},
    "22111": {"debit": "0365", "credit": "0366"}, "22112": {"debit": "0367", "credit": "0368"}, "22113": {"debit": "0369", "credit": "0370"},
    "22114": {"debit": "0371", "credit": "0372"}, "22115": {"debit": "0373", "credit": "0374"}, "22118": {"debit": "0375", "credit": "0376"},
    "2212": {"debit": "0377", "credit": "0378"}, "22121": {"debit": "0379", "credit": "0380"}, "22122": {"debit": "0381", "credit": "0382"},
    "22123": {"debit": "0383", "credit": "0384"}, "22124": {"debit": "0385", "credit": "0386"}, "22125": {"debit": "0387", "credit": "0388"},
    "22128": {"debit": "0389", "credit": "0390"}, "2213": {"debit": "0391", "credit": "0392"}, "22131": {"debit": "0393", "credit": "0394"},
    "22132": {"debit": "0395", "credit": "0396"}, "222": {"debit": "0397", "credit": "0398"}, "2221": {"debit": "0399", "credit": "0400"},
    "2222": {"debit": "0401", "credit": "0402"}, "223": {"debit": "0403", "credit": "0404"}, "2231": {"debit": "0405", "credit": "0406"},
    "2232": {"debit": "0407", "credit": "0408"}, "2233": {"debit": "0409", "credit": "0410"}, "2234": {"debit": "0411", "credit": "0412"},
    "2235": {"debit": "0413", "credit": "0414"}, "2236": {"debit": "0415", "credit": "0416"}, "2237": {"debit": "0417", "credit": "0418"},
    "2238": {"debit": "0419", "credit": "0420"}, "224": {"debit": "0421", "credit": "0422"}, "2241": {"debit": "0423", "credit": "0424"},
    "22411": {"debit": "0425", "credit": "0426"}, "22412": {"debit": "0427", "credit": "0428"}, "22413": {"debit": "0429", "credit": "0430"},
    "2242": {"debit": "0431", "credit": "0432"}, "2243": {"debit": "0433", "credit": "0434"}, "23": {"debit": "0435", "credit": "0436"},
    "231": {"debit": "0437", "credit": "0438"}, "232": {"debit": "0439", "credit": "0440"}, "233": {"debit": "0441", "credit": "0442"},
    "234": {"debit": "0443", "credit": "0444"}, "235": {"debit": "0445", "credit": "0446"}, "2351": {"debit": "0447", "credit": "0448"},
    "23511": {"debit": "0449", "credit": "0450"}, "23518": {"debit": "0451", "credit": "0452"}, "2352": {"debit": "0453", "credit": "0454"},
    "23521": {"debit": "0455", "credit": "0456"}, "23528": {"debit": "0457", "credit": "0458"}, "2358": {"debit": "0459", "credit": "0460"},
    "236": {"debit": "0461", "credit": "0462"}, "2361": {"debit": "0463", "credit": "0464"}, "23611": {"debit": "0465", "credit": "0466"},
    "23612": {"debit": "0467", "credit": "0468"}, "23613": {"debit": "0469", "credit": "0470"}, "23618": {"debit": "0471", "credit": "0472"},
    "2362": {"debit": "0473", "credit": "0474"}, "23621": {"debit": "0475", "credit": "0476"}, "23622": {"debit": "0477", "credit": "0478"},
    "2363": {"debit": "0479", "credit": "0480"}, "237": {"debit": "0481", "credit": "0482"}, "30": {"debit": "0483", "credit": "0484"},
    "301": {"debit": "0485", "credit": "0486"}, "302": {"debit": "0487", "credit": "0488"}, "303": {"debit": "0489", "credit": "0490"},
    "3031": {"debit": "0491", "credit": "0492"}, "3032": {"debit": "0493", "credit": "0494"}, "3033": {"debit": "0495", "credit": "0496"},
    "3034": {"debit": "0497", "credit": "0498"}, "3035": {"debit": "0499", "credit": "0500"}, "3036": {"debit": "0501", "credit": "0502"},
    "3037": {"debit": "0503", "credit": "0504"}, "3038": {"debit": "0505", "credit": "0506"}, "304": {"debit": "0507", "credit": "0508"},
    "3041": {"debit": "0509", "credit": "0510"}, "3042": {"debit": "0511", "credit": "0512"}, "3043": {"debit": "0513", "credit": "0514"},
    "305": {"debit": "0515", "credit": "0516"}, "31": {"debit": "0517", "credit": "0518"}, "311": {"debit": "0519", "credit": "0520"},
    "312": {"debit": "0521", "credit": "0522"}, "313": {"debit": "0523", "credit": "0524"}, "314": {"debit": "0525", "credit": "0526"},
    "32": {"debit": "0527", "credit": "0528"}, "321": {"debit": "0529", "credit": "0530"}, "322": {"debit": "0531", "credit": "0532"},
    "323": {"debit": "0533", "credit": "0534"}, "3231": {"debit": "0535", "credit": "0536"}, "3232": {"debit": "0537", "credit": "0538"},
    "3233": {"debit": "0539", "credit": "0540"}, "326": {"debit": "0541", "credit": "0542"}, "327": {"debit": "0543", "credit": "0544"},
    "33": {"debit": "0545", "credit": "0546"}, "331": {"debit": "0547", "credit": "0548"}, "332": {"debit": "0549", "credit": "0550"},
    "3321": {"debit": "0551", "credit": "0552"}, "3322": {"debit": "0553", "credit": "0554"}, "34": {"debit": "0555", "credit": "0556"},
    "341": {"debit": "0557", "credit": "0558"}, "342": {"debit": "0559", "credit": "0560"}, "343": {"debit": "0561", "credit": "0562"},
    "344": {"debit": "0563", "credit": "0564"}, "40": {"debit": "0565", "credit": "0566"}, "401": {"debit": "0567", "credit": "0568"},
    "4011": {"debit": "0569", "credit": "0570"}, "4012": {"debit": "0571", "credit": "0572"}, "4013": {"debit": "0573", "credit": "0574"},
    "4014": {"debit": "0575", "credit": "0576"}, "4015": {"debit": "0577", "credit": "0578"}, "4019": {"debit": "0579", "credit": "0580"},
    "402": {"debit": "0581", "credit": "0582"}, "4021": {"debit": "0583", "credit": "0584"}, "4022": {"debit": "0585", "credit": "0586"},
    "4023": {"debit": "0587", "credit": "0588"}, "4024": {"debit": "0589", "credit": "0590"}, "4025": {"debit": "0591", "credit": "0592"},
    "4029": {"debit": "0593", "credit": "0594"}, "41": {"debit": "0595", "credit": "0596"}, "411": {"debit": "0597", "credit": "0598"},
    "4111": {"debit": "0599", "credit": "0600"}, "41111": {"debit": "0601", "credit": "0602"}, "41112": {"debit": "0603", "credit": "0604"},
    "41113": {"debit": "0605", "credit": "0606"}, "41114": {"debit": "0607", "credit": "0608"}, "41118": {"debit": "0609", "credit": "0610"},
    "41119": {"debit": "0611", "credit": "0612"}, "4112": {"debit": "0613", "credit": "0614"}, "41121": {"debit": "0615", "credit": "0616"},
    "41122": {"debit": "0617", "credit": "0618"}, "41123": {"debit": "0619", "credit": "0620"}, "41124": {"debit": "0621", "credit": "0622"},
    "41128": {"debit": "0623", "credit": "0624"}, "41129": {"debit": "0625", "credit": "0626"}, "412": {"debit": "0627", "credit": "0628"},
    "4121": {"debit": "0629", "credit": "0630"}, "41211": {"debit": "0631", "credit": "0632"}, "41212": {"debit": "0633", "credit": "0634"},
    "41213": {"debit": "0635", "credit": "0636"}, "41214": {"debit": "0637", "credit": "0638"}, "41218": {"debit": "0639", "credit": "0640"},
    "41219": {"debit": "0641", "credit": "0642"}, "4122": {"debit": "0643", "credit": "0644"}, "41221": {"debit": "0645", "credit": "0646"},
    "41222": {"debit": "0647", "credit": "0648"}, "41223": {"debit": "0649", "credit": "0650"}, "41224": {"debit": "0651", "credit": "0652"},
    "41228": {"debit": "0653", "credit": "0654"}, "41229": {"debit": "0655", "credit": "0656"}, "42": {"debit": "0657", "credit": "0658"},
    "421": {"debit": "0659", "credit": "0660"}, "4211": {"debit": "0661", "credit": "0662"}, "42111": {"debit": "0663", "credit": "0664"},
    "42119": {"debit": "0665", "credit": "0666"}, "4212": {"debit": "0667", "credit": "0668"}, "42121": {"debit": "0669", "credit": "0670"},
    "42122": {"debit": "0671", "credit": "0672"}, "42129": {"debit": "0673", "credit": "0674"}, "4213": {"debit": "0675", "credit": "0676"},
    "42131": {"debit": "0677", "credit": "0678"}, "42132": {"debit": "0679", "credit": "0680"}, "42138": {"debit": "0681", "credit": "0682"},
    "4214": {"debit": "0683", "credit": "0684"}, "4215": {"debit": "0685", "credit": "0686"}, "4216": {"debit": "0687", "credit": "0688"},
    "42161": {"debit": "0689", "credit": "0690"}, "421611": {"debit": "0691", "credit": "0692"}, "421612": {"debit": "0693", "credit": "0694"},
    "421613": {"debit": "0695", "credit": "0696"}, "421618": {"debit": "0697", "credit": "0698"}, "42162": {"debit": "0699", "credit": "0700"},
    "421621": {"debit": "0701", "credit": "0702"}, "421622": {"debit": "0703", "credit": "0704"}, "421623": {"debit": "0705", "credit": "0706"},
    "421624": {"debit": "0707", "credit": "0708"}, "421628": {"debit": "0709", "credit": "0710"}, "42168": {"debit": "0711", "credit": "0712"},
    "4217": {"debit": "0713", "credit": "0714"}, "42171": {"debit": "0715", "credit": "0716"}, "42172": {"debit": "0717", "credit": "0718"},
    "42178": {"debit": "0719", "credit": "0720"}, "4218": {"debit": "0721", "credit": "0722"}, "42181": {"debit": "0723", "credit": "0724"},
    "421811": {"debit": "0725", "credit": "0726"}, "421818": {"debit": "0727", "credit": "0728"}, "42188": {"debit": "0729", "credit": "0730"},
    "42189": {"debit": "0731", "credit": "0732"}, "422": {"debit": "0733", "credit": "0734"}, "4221": {"debit": "0735", "credit": "0736"},
    "42211": {"debit": "0737", "credit": "0738"}, "42219": {"debit": "0739", "credit": "0740"}, "4222": {"debit": "0741", "credit": "0742"},
    "42221": {"debit": "0743", "credit": "0744"}, "42222": {"debit": "0745", "credit": "0746"}, "42229": {"debit": "0747", "credit": "0748"},
    "4223": {"debit": "0749", "credit": "0750"}, "42231": {"debit": "0751", "credit": "0752"}, "42232": {"debit": "0753", "credit": "0754"},
    "42238": {"debit": "0755", "credit": "0756"}, "4224": {"debit": "0757", "credit": "0758"}, "4225": {"debit": "0759", "credit": "0760"},
    "4226": {"debit": "0761", "credit": "0762"}, "42261": {"debit": "0763", "credit": "0764"}, "422611": {"debit": "0765", "credit": "0766"},
    "422612": {"debit": "0767", "credit": "0768"}, "422613": {"debit": "0769", "credit": "0770"}, "422618": {"debit": "0771", "credit": "0772"},
    "42262": {"debit": "0773", "credit": "0774"}, "422621": {"debit": "0775", "credit": "0776"}, "422622": {"debit": "0777", "credit": "0778"},
    "422623": {"debit": "0779", "credit": "0780"}, "422624": {"debit": "0781", "credit": "0782"}, "422628": {"debit": "0783", "credit": "0784"},
    "4227": {"debit": "0785", "credit": "0786"}, "42271": {"debit": "0787", "credit": "0788"}, "42272": {"debit": "0789", "credit": "0790"},
    "42278": {"debit": "0791", "credit": "0792"}, "4228": {"debit": "0793", "credit": "0794"}, "42281": {"debit": "0795", "credit": "0796"},
    "422811": {"debit": "0797", "credit": "0798"}, "422818": {"debit": "0799", "credit": "0800"}, "42288": {"debit": "0801", "credit": "0802"},
    "42289": {"debit": "0803", "credit": "0804"}, "43": {"debit": "0805", "credit": "0806"}, "431": {"debit": "0807", "credit": "0808"},
    "432": {"debit": "0809", "credit": "0810"}, "44": {"debit": "0811", "credit": "0812"}, "441": {"debit": "0813", "credit": "0814"},
    "4411": {"debit": "0815", "credit": "0816"}, "44111": {"debit": "0817", "credit": "0818"}, "44112": {"debit": "0819", "credit": "0820"},
    "44113": {"debit": "0821", "credit": "0822"}, "441131": {"debit": "0823", "credit": "0824"}, "441132": {"debit": "0825", "credit": "0826"},
    "441133": {"debit": "0827", "credit": "0828"}, "441134": {"debit": "0829", "credit": "0830"}, "4412": {"debit": "0831", "credit": "0832"},
    "44121": {"debit": "0833", "credit": "0834"}, "44122": {"debit": "0835", "credit": "0836"}, "44123": {"debit": "0837", "credit": "0838"},
    "441231": {"debit": "0839", "credit": "0840"}, "441232": {"debit": "0841", "credit": "0842"}, "441233": {"debit": "0843", "credit": "0844"},
    "441234": {"debit": "0845", "credit": "0846"}, "442": {"debit": "0847", "credit": "0848"}, "4421": {"debit": "0849", "credit": "0850"},
    "4422": {"debit": "0851", "credit": "0852"}, "45": {"debit": "0853", "credit": "0854"}, "451": {"debit": "0855", "credit": "0856"},
    "4511": {"debit": "0857", "credit": "0858"}, "45111": {"debit": "0859", "credit": "0860"}, "45112": {"debit": "0861", "credit": "0862"},
    "45113": {"debit": "0863", "credit": "0864"}, "45114": {"debit": "0865", "credit": "0866"}, "45118": {"debit": "0867", "credit": "0868"},
    "4512": {"debit": "0869", "credit": "0870"}, "45121": {"debit": "0871", "credit": "0872"}, "45122": {"debit": "0873", "credit": "0874"},
    "45123": {"debit": "0875", "credit": "0876"}, "45124": {"debit": "0877", "credit": "0878"}, "45128": {"debit": "0879", "credit": "0880"},
    "452": {"debit": "0881", "credit": "0882"}, "4521": {"debit": "0883", "credit": "0884"}, "45211": {"debit": "0885", "credit": "0886"},
    "45212": {"debit": "0887", "credit": "0888"}, "45213": {"debit": "0889", "credit": "0890"}, "45214": {"debit": "0891", "credit": "0892"},
    "45218": {"debit": "0893", "credit": "0894"}, "4522": {"debit": "0895", "credit": "0896"}, "45221": {"debit": "0897", "credit": "0898"},
    "45222": {"debit": "0899", "credit": "0900"}, "45223": {"debit": "0901", "credit": "0902"}, "45224": {"debit": "0903", "credit": "0904"},
    "45228": {"debit": "0905", "credit": "0906"}, "46": {"debit": "0907", "credit": "0908"}, "461": {"debit": "0909", "credit": "0910"},
    "4611": {"debit": "0911", "credit": "0912"}, "46111": {"debit": "0913", "credit": "0914"}, "46112": {"debit": "0915", "credit": "0916"},
    "4612": {"debit": "0917", "credit": "0918"}, "46121": {"debit": "0919", "credit": "0920"}, "461211": {"debit": "0921", "credit": "0922"},
    "461212": {"debit": "0923", "credit": "0924"}, "46122": {"debit": "0925", "credit": "0926"}, "461221": {"debit": "0927", "credit": "0928"},
    "461222": {"debit": "0929", "credit": "0930"}, "46123": {"debit": "0931", "credit": "0932"}, "461231": {"debit": "0933", "credit": "0934"},
    "461232": {"debit": "0935", "credit": "0936"}, "46124": {"debit": "0937", "credit": "0938"}, "46125": {"debit": "0939", "credit": "0940"},
    "46126": {"debit": "0941", "credit": "0942"}, "46128": {"debit": "0943", "credit": "0944"}, "4613": {"debit": "0945", "credit": "0946"},
    "46131": {"debit": "0947", "credit": "0948"}, "46132": {"debit": "0949", "credit": "0950"}, "46138": {"debit": "0951", "credit": "0952"},
    "4614": {"debit": "0953", "credit": "0954"}, "46141": {"debit": "0955", "credit": "0956"}, "461411": {"debit": "0957", "credit": "0958"},
    "461412": {"debit": "0959", "credit": "0960"}, "461413": {"debit": "0961", "credit": "0962"}, "461418": {"debit": "0963", "credit": "0964"},
    "46142": {"debit": "0965", "credit": "0966"}, "461421": {"debit": "0967", "credit": "0968"}, "461422": {"debit": "0969", "credit": "0970"},
    "461423": {"debit": "0971", "credit": "0972"}, "461424": {"debit": "0973", "credit": "0974"}, "461428": {"debit": "0975", "credit": "0976"},
    "4615": {"debit": "0977", "credit": "0978"}, "462": {"debit": "0979", "credit": "0980"}, "4621": {"debit": "0981", "credit": "0982"},
    "4622": {"debit": "0983", "credit": "0984"}, "4628": {"debit": "0985", "credit": "0986"}, "47": {"debit": "0987", "credit": "0988"},
    "471": {"debit": "0989", "credit": "0990"}, "4711": {"debit": "0991", "credit": "0992"}, "47111": {"debit": "0993", "credit": "0994"},
    "47112": {"debit": "0995", "credit": "0996"}, "47113": {"debit": "0997", "credit": "0998"}, "4712": {"debit": "0999", "credit": "1000"},
    "47121": {"debit": "1001", "credit": "1002"}, "47122": {"debit": "1003", "credit": "1004"}, "4713": {"debit": "1005", "credit": "1006"},
    "4714": {"debit": "1007", "credit": "1008"}, "47141": {"debit": "1009", "credit": "1010"}, "47142": {"debit": "1011", "credit": "1012"},
    "47143": {"debit": "1013", "credit": "1014"}, "47148": {"debit": "1015", "credit": "1016"}, "4715": {"debit": "1017", "credit": "1018"},
    "4718": {"debit": "1019", "credit": "1020"}, "472": {"debit": "1021", "credit": "1022"}, "4721": {"debit": "1023", "credit": "1024"},
    "47211": {"debit": "1025", "credit": "1026"}, "47212": {"debit": "1027", "credit": "1028"}, "47213": {"debit": "1029", "credit": "1030"},
    "4722": {"debit": "1031", "credit": "1032"}, "47221": {"debit": "1033", "credit": "1034"}, "47222": {"debit": "1035", "credit": "1036"},
    "4723": {"debit": "1037", "credit": "1038"}, "4724": {"debit": "1039", "credit": "1040"}, "47241": {"debit": "1041", "credit": "1042"},
    "47242": {"debit": "1043", "credit": "1044"}, "47243": {"debit": "1045", "credit": "1046"}, "47248": {"debit": "1047", "credit": "1048"},
    "4726": {"debit": "1049", "credit": "1050"}, "4728": {"debit": "1051", "credit": "1052"}, "48": {"debit": "1053", "credit": "1054"},
    "481": {"debit": "1055", "credit": "1056"}, "482": {"debit": "1057", "credit": "1058"}, "483": {"debit": "1059", "credit": "1060"},
    "484": {"debit": "1061", "credit": "1062"}, "485": {"debit": "1063", "credit": "1064"}, "486": {"debit": "1065", "credit": "1066"},
    "487": {"debit": "1067", "credit": "1068"}, "50": {"debit": "1069", "credit": "1070"}, "501": {"debit": "1071", "credit": "1072"},
    "502": {"debit": "1073", "credit": "1074"}, "503": {"debit": "1075", "credit": "1076"}, "508": {"debit": "1077", "credit": "1078"},
    "5081": {"debit": "1079", "credit": "1080"}, "5082": {"debit": "1081", "credit": "1082"}, "5083": {"debit": "1083", "credit": "1084"},
    "5084": {"debit": "1085", "credit": "1086"}, "5085": {"debit": "1087", "credit": "1088"}, "5088": {"debit": "1089", "credit": "1090"},
    "51": {"debit": "1091", "credit": "1092"}, "511": {"debit": "1093", "credit": "1094"}, "512": {"debit": "1095", "credit": "1096"},
    "513": {"debit": "1097", "credit": "1098"}, "5131": {"debit": "1099", "credit": "1100"}, "5132": {"debit": "1101", "credit": "1102"},
    "514": {"debit": "1103", "credit": "1104"}, "516": {"debit": "1105", "credit": "1106"}, "517": {"debit": "1107", "credit": "1108"},
    "518": {"debit": "1109", "credit": "1110"}, "60": {"debit": "1113", "credit": "1114"}, "601": {"debit": "1115", "credit": "1116"},
    "602": {"debit": "1117", "credit": "1118"}, "603": {"debit": "1119", "credit": "1120"}, "6031": {"debit": "1121", "credit": "1122"},
    "60311": {"debit": "1123", "credit": "1124"}, "60312": {"debit": "1125", "credit": "1126"}, "60313": {"debit": "1127", "credit": "1128"},
    "6032": {"debit": "1129", "credit": "1130"}, "6033": {"debit": "1131", "credit": "1132"}, "6034": {"debit": "1133", "credit": "1134"},
    "6035": {"debit": "1135", "credit": "1136"}, "6036": {"debit": "1137", "credit": "1138"}, "6037": {"debit": "1139", "credit": "1140"},
    "6038": {"debit": "1141", "credit": "1142"}, "604": {"debit": "1143", "credit": "1144"}, "6041": {"debit": "1145", "credit": "1146"},
    "6042": {"debit": "1147", "credit": "1148"}, "6043": {"debit": "1149", "credit": "1150"}, "605": {"debit": "1151", "credit": "1152"},
    "606": {"debit": "1153", "credit": "1154"}, "6061": {"debit": "1155", "credit": "1156"}, "6062": {"debit": "1157", "credit": "1158"},
    "6063": {"debit": "1159", "credit": "1160"}, "607": {"debit": "1161", "credit": "1162"}, "6071": {"debit": "1163", "credit": "1164"},
    "6072": {"debit": "1165", "credit": "1166"}, "6073": {"debit": "1167", "credit": "1168"}, "6074": {"debit": "1169", "credit": "1170"},
    "6075": {"debit": "1171", "credit": "1172"}, "6076": {"debit": "1173", "credit": "1174"}, "608": {"debit": "1175", "credit": "1176"},
    "6081": {"debit": "1177", "credit": "1178"}, "60811": {"debit": "1179", "credit": "1180"}, "608111": {"debit": "1181", "credit": "1182"},
    "608112": {"debit": "1183", "credit": "1184"}, "608113": {"debit": "1185", "credit": "1186"}, "60812": {"debit": "1187", "credit": "1188"},
    "60813": {"debit": "1189", "credit": "1190"}, "60814": {"debit": "1191", "credit": "1192"}, "60815": {"debit": "1193", "credit": "1194"},
    "60816": {"debit": "1195", "credit": "1196"}, "60818": {"debit": "1197", "credit": "1198"}, "6082": {"debit": "1199", "credit": "1200"},
    "60821": {"debit": "1201", "credit": "1202"}, "608211": {"debit": "1203", "credit": "1204"}, "608212": {"debit": "1205", "credit": "1206"},
    "608213": {"debit": "1207", "credit": "1208"}, "60822": {"debit": "1209", "credit": "1210"}, "60828": {"debit": "1211", "credit": "1212"},
    "609": {"debit": "1213", "credit": "1214"}, "6091": {"debit": "1215", "credit": "1216"}, "6092": {"debit": "1217", "credit": "1218"},
    "6093": {"debit": "1219", "credit": "1220"}, "6094": {"debit": "1221", "credit": "1222"}, "6095": {"debit": "1223", "credit": "1224"},
    "6096": {"debit": "1225", "credit": "1226"}, "6098": {"debit": "1227", "credit": "1228"}, "6099": {"debit": "1229", "credit": "1230"},
    "61": {"debit": "1231", "credit": "1232"}, "611": {"debit": "1233", "credit": "1234"}, "6111": {"debit": "1235", "credit": "1236"},
    "61111": {"debit": "1237", "credit": "1238"}, "61112": {"debit": "1239", "credit": "1240"}, "6112": {"debit": "1241", "credit": "1242"},
    "61121": {"debit": "1243", "credit": "1244"}, "61122": {"debit": "1245", "credit": "1246"}, "61123": {"debit": "1247", "credit": "1248"},
    "6113": {"debit": "1249", "credit": "1250"}, "6114": {"debit": "1251", "credit": "1252"}, "61141": {"debit": "1253", "credit": "1254"},
    "61142": {"debit": "1255", "credit": "1256"}, "6115": {"debit": "1257", "credit": "1258"}, "61151": {"debit": "1259", "credit": "1260"},
    "61152": {"debit": "1261", "credit": "1262"}, "61153": {"debit": "1263", "credit": "1264"}, "6116": {"debit": "1265", "credit": "1266"},
    "612": {"debit": "1267", "credit": "1268"}, "6121": {"debit": "1269", "credit": "1270"}, "6122": {"debit": "1271", "credit": "1272"},
    "61221": {"debit": "1273", "credit": "1274"}, "61222": {"debit": "1275", "credit": "1276"}, "61223": {"debit": "1277", "credit": "1278"},
    "6123": {"debit": "1279", "credit": "1280"}, "6124": {"debit": "1281", "credit": "1282"}, "613": {"debit": "1283", "credit": "1284"},
    "6131": {"debit": "1285", "credit": "1286"}, "61311": {"debit": "1287", "credit": "1288"}, "61312": {"debit": "1289", "credit": "1290"},
    "61313": {"debit": "1291", "credit": "1292"}, "6132": {"debit": "1293", "credit": "1294"}, "6133": {"debit": "1295", "credit": "1296"},
    "61331": {"debit": "1297", "credit": "1298"}, "61332": {"debit": "1299", "credit": "1300"}, "61333": {"debit": "1301", "credit": "1302"},
    "61334": {"debit": "1303", "credit": "1304"}, "61335": {"debit": "1305", "credit": "1306"}, "61336": {"debit": "1307", "credit": "1308"},
    "61337": {"debit": "1309", "credit": "1310"}, "61338": {"debit": "1311", "credit": "1312"}, "6134": {"debit": "1313", "credit": "1314"},
    "61341": {"debit": "1315", "credit": "1316"}, "61342": {"debit": "1317", "credit": "1318"}, "61343": {"debit": "1319", "credit": "1320"},
    "61348": {"debit": "1321", "credit": "1322"}, "6135": {"debit": "1323", "credit": "1324"}, "6136": {"debit": "1325", "credit": "1326"},
    "6138": {"debit": "1327", "credit": "1328"}, "614": {"debit": "1329", "credit": "1330"}, "6141": {"debit": "1331", "credit": "1332"},
    "61411": {"debit": "1333", "credit": "1334"}, "61412": {"debit": "1335", "credit": "1336"}, "61413": {"debit": "1337", "credit": "1338"},
    "61418": {"debit": "1339", "credit": "1340"}, "6142": {"debit": "1341", "credit": "1342"}, "6143": {"debit": "1343", "credit": "1344"},
    "61431": {"debit": "1345", "credit": "1346"}, "61432": {"debit": "1347", "credit": "1348"}, "61438": {"debit": "1349", "credit": "1350"},
    "6144": {"debit": "1351", "credit": "1352"}, "6145": {"debit": "1353", "credit": "1354"}, "6146": {"debit": "1355", "credit": "1356"},
    "6148": {"debit": "1357", "credit": "1358"}, "615": {"debit": "1359", "credit": "1360"}, "6151": {"debit": "1361", "credit": "1362"},
    "61511": {"debit": "1363", "credit": "1364"}, "61512": {"debit": "1365", "credit": "1366"}, "61513": {"debit": "1367", "credit": "1368"},
    "61514": {"debit": "1369", "credit": "1370"}, "61515": {"debit": "1371", "credit": "1372"}, "61516": {"debit": "1373", "credit": "1374"},
    "61517": {"debit": "1375", "credit": "1376"}, "61518": {"debit": "1377", "credit": "1378"}, "6152": {"debit": "1379", "credit": "1380"},
    "61521": {"debit": "1381", "credit": "1382"}, "615211": {"debit": "1383", "credit": "1384"}, "615212": {"debit": "1385", "credit": "1386"},
    "61522": {"debit": "1387", "credit": "1388"}, "61523": {"debit": "1389", "credit": "1390"}, "61524": {"debit": "1391", "credit": "1392"},
    "6153": {"debit": "1393", "credit": "1394"}, "61531": {"debit": "1395", "credit": "1396"}, "61532": {"debit": "1397", "credit": "1398"},
    "61538": {"debit": "1399", "credit": "1400"}, "616": {"debit": "1401", "credit": "1402"}, "6161": {"debit": "1403", "credit": "1404"},
    "6162": {"debit": "1405", "credit": "1406"}, "6163": {"debit": "1407", "credit": "1408"}, "6164": {"debit": "1409", "credit": "1410"},
    "6165": {"debit": "1411", "credit": "1412"}, "6168": {"debit": "1413", "credit": "1414"}, "617": {"debit": "1415", "credit": "1416"},
    "6171": {"debit": "1417", "credit": "1418"}, "6172": {"debit": "1419", "credit": "1420"}, "618": {"debit": "1421", "credit": "1422"},
    "6181": {"debit": "1423", "credit": "1424"}, "61811": {"debit": "1425", "credit": "1426"}, "61812": {"debit": "1427", "credit": "1428"},
    "6182": {"debit": "1429", "credit": "1430"}, "6183": {"debit": "1431", "credit": "1432"}, "6184": {"debit": "1433", "credit": "1434"},
    "6185": {"debit": "1435", "credit": "1436"}, "6186": {"debit": "1437", "credit": "1438"}, "6187": {"debit": "1439", "credit": "1440"},
    "6188": {"debit": "1441", "credit": "1442"}, "619": {"debit": "1443", "credit": "1444"}, "62": {"debit": "1445", "credit": "1446"},
    "621": {"debit": "1447", "credit": "1448"}, "6211": {"debit": "1449", "credit": "1450"}, "62111": {"debit": "1451", "credit": "1452"},
    "62112": {"debit": "1453", "credit": "1454"}, "621121": {"debit": "1455", "credit": "1456"}, "621122": {"debit": "1457", "credit": "1458"},
    "621123": {"debit": "1459", "credit": "1460"}, "621128": {"debit": "1461", "credit": "1462"}, "62113": {"debit": "1463", "credit": "1464"},
    "62114": {"debit": "1465", "credit": "1466"}, "62115": {"debit": "1467", "credit": "1468"}, "62116": {"debit": "1469", "credit": "1470"},
    "62117": {"debit": "1471", "credit": "1472"}, "6218": {"debit": "1473", "credit": "1474"}, "6219": {"debit": "1475", "credit": "1476"},
    "62191": {"debit": "1477", "credit": "1478"}, "62192": {"debit": "1479", "credit": "1480"}, "62193": {"debit": "1481", "credit": "1482"},
    "622": {"debit": "1483", "credit": "1484"}, "6221": {"debit": "1485", "credit": "1486"}, "6222": {"debit": "1487", "credit": "1488"},
    "6228": {"debit": "1489", "credit": "1490"}, "623": {"debit": "1491", "credit": "1492"}, "6231": {"debit": "1493", "credit": "1494"},
    "62311": {"debit": "1495", "credit": "1496"}, "62312": {"debit": "1497", "credit": "1498"}, "62318": {"debit": "1499", "credit": "1500"},
    "6232": {"debit": "1501", "credit": "1502"}, "6233": {"debit": "1503", "credit": "1504"}, "6238": {"debit": "1505", "credit": "1506"},
    "6239": {"debit": "1507", "credit": "1508"}, "624": {"debit": "1509", "credit": "1510"}, "6241": {"debit": "1511", "credit": "1512"},
    "6242": {"debit": "1513", "credit": "1514"}, "6243": {"debit": "1515", "credit": "1516"}, "6244": {"debit": "1517", "credit": "1518"},
    "6245": {"debit": "1519", "credit": "1520"}, "628": {"debit": "1521", "credit": "1522"}, "6281": {"debit": "1523", "credit": "1524"},
    "6288": {"debit": "1525", "credit": "1526"}, "63": {"debit": "1527", "credit": "1528"}, "631": {"debit": "1529", "credit": "1530"},
    "6311": {"debit": "1531", "credit": "1532"}, "6312": {"debit": "1533", "credit": "1534"}, "6313": {"debit": "1535", "credit": "1536"},
    "6314": {"debit": "1537", "credit": "1538"}, "6318": {"debit": "1539", "credit": "1540"}, "632": {"debit": "1541", "credit": "1542"},
    "6321": {"debit": "1543", "credit": "1544"}, "6322": {"debit": "1545", "credit": "1546"}, "6323": {"debit": "1547", "credit": "1548"},
    "6324": {"debit": "1549", "credit": "1550"}, "633": {"debit": "1551", "credit": "1552"}, "6331": {"debit": "1553", "credit": "1554"},
    "63311": {"debit": "1555", "credit": "1556"}, "63312": {"debit": "1557", "credit": "1558"}, "63313": {"debit": "1559", "credit": "1560"},
    "6332": {"debit": "1561", "credit": "1562"}, "6333": {"debit": "1563", "credit": "1564"}, "6334": {"debit": "1565", "credit": "1566"},
    "634": {"debit": "1567", "credit": "1568"}, "6341": {"debit": "1569", "credit": "1570"}, "6342": {"debit": "1571", "credit": "1572"},
    "6343": {"debit": "1573", "credit": "1574"}, "6344": {"debit": "1575", "credit": "1576"}, "6345": {"debit": "1577", "credit": "1578"},
    "635": {"debit": "1579", "credit": "1580"}, "6351": {"debit": "1581", "credit": "1582"}, "6352": {"debit": "1583", "credit": "1584"},
    "6353": {"debit": "1585", "credit": "1586"}, "64": {"debit": "1587", "credit": "1588"}, "641": {"debit": "1589", "credit": "1590"},
    "6411": {"debit": "1591", "credit": "1592"}, "6412": {"debit": "1593", "credit": "1594"}, "6413": {"debit": "1595", "credit": "1596"},
    "6414": {"debit": "1597", "credit": "1598"}, "6415": {"debit": "1599", "credit": "1600"}, "64151": {"debit": "1601", "credit": "1602"},
    "64158": {"debit": "1603", "credit": "1604"}, "642": {"debit": "1605", "credit": "1606"}, "643": {"debit": "1607", "credit": "1608"},
    "644": {"debit": "1609", "credit": "1610"}, "645": {"debit": "1611", "credit": "1612"}, "6451": {"debit": "1613", "credit": "1614"},
    "6452": {"debit": "1615", "credit": "1616"}, "6453": {"debit": "1617", "credit": "1618"}, "646": {"debit": "1619", "credit": "1620"},
    "6461": {"debit": "1621", "credit": "1622"}, "6462": {"debit": "1623", "credit": "1624"}, "6463": {"debit": "1625", "credit": "1626"},
    "64631": {"debit": "1627", "credit": "1628"}, "64632": {"debit": "1629", "credit": "1630"}, "64633": {"debit": "1631", "credit": "1632"},
    "6464": {"debit": "1633", "credit": "1634"}, "6465": {"debit": "1635", "credit": "1636"}, "64651": {"debit": "1637", "credit": "1638"},
    "64652": {"debit": "1639", "credit": "1640"}, "64653": {"debit": "1641", "credit": "1642"}, "64654": {"debit": "1643", "credit": "1644"},
    "64658": {"debit": "1645", "credit": "1646"}, "6466": {"debit": "1647", "credit": "1648"}, "6467": {"debit": "1649", "credit": "1650"},
    "6468": {"debit": "1651", "credit": "1652"}, "6469": {"debit": "1653", "credit": "1654"}, "647": {"debit": "1655", "credit": "1656"},
    "648": {"debit": "1657", "credit": "1658"}, "649": {"debit": "1659", "credit": "1660"}, "65": {"debit": "1661", "credit": "1662"},
    "651": {"debit": "1663", "credit": "1664"}, "6511": {"debit": "1665", "credit": "1666"}, "65111": {"debit": "1667", "credit": "1668"},
    "65112": {"debit": "1669", "credit": "1670"}, "65113": {"debit": "1671", "credit": "1672"}, "65114": {"debit": "1673", "credit": "1674"},
    "65115": {"debit": "1675", "credit": "1676"}, "65116": {"debit": "1677", "credit": "1678"}, "65117": {"debit": "1679", "credit": "1680"},
    "6512": {"debit": "1681", "credit": "1682"}, "653": {"debit": "1683", "credit": "1684"}, "6531": {"debit": "1685", "credit": "1686"},
    "65311": {"debit": "1687", "credit": "1688"}, "65312": {"debit": "1689", "credit": "1690"}, "65313": {"debit": "1691", "credit": "1692"},
    "65318": {"debit": "1693", "credit": "1694"}, "6532": {"debit": "1695", "credit": "1696"}, "6533": {"debit": "1697", "credit": "1698"},
    "6534": {"debit": "1699", "credit": "1700"}, "654": {"debit": "1701", "credit": "1702"}, "6541": {"debit": "1703", "credit": "1704"},
    "6542": {"debit": "1705", "credit": "1706"}, "6543": {"debit": "1707", "credit": "1708"}, "6548": {"debit": "1709", "credit": "1710"},
    "655": {"debit": "1711", "credit": "1712"}, "6551": {"debit": "1713", "credit": "1714"}, "65511": {"debit": "1715", "credit": "1716"},
    "65512": {"debit": "1717", "credit": "1718"}, "6552": {"debit": "1719", "credit": "1720"}, "65521": {"debit": "1721", "credit": "1722"},
    "65522": {"debit": "1723", "credit": "1724"}, "65523": {"debit": "1725", "credit": "1726"}, "6553": {"debit": "1727", "credit": "1728"},
    "6554": {"debit": "1729", "credit": "1730"}, "6555": {"debit": "1731", "credit": "1732"}, "6556": {"debit": "1733", "credit": "1734"},
    "6558": {"debit": "1735", "credit": "1736"}, "656": {"debit": "1737", "credit": "1738"}, "657": {"debit": "1739", "credit": "1740"},
    "658": {"debit": "1741", "credit": "1742"}, "659": {"debit": "1743", "credit": "1744"}, "66": {"debit": "1745", "credit": "1746"},
    "661": {"debit": "1747", "credit": "1748"}, "6611": {"debit": "1749", "credit": "1750"}, "6612": {"debit": "1751", "credit": "1752"},
    "662": {"debit": "1753", "credit": "1754"}, "6621": {"debit": "1755", "credit": "1756"}, "6622": {"debit": "1757", "credit": "1758"},
    "663": {"debit": "1759", "credit": "1760"}, "6631": {"debit": "1761", "credit": "1762"}, "6632": {"debit": "1763", "credit": "1764"},
    "664": {"debit": "1765", "credit": "1766"}, "6641": {"debit": "1767", "credit": "1768"}, "6642": {"debit": "1769", "credit": "1770"},
    "6643": {"debit": "1771", "credit": "1772"}, "6644": {"debit": "1773", "credit": "1774"}, "6645": {"debit": "1775", "credit": "1776"},
    "6646": {"debit": "1777", "credit": "1778"}, "6647": {"debit": "1779", "credit": "1780"}, "665": {"debit": "1781", "credit": "1782"},
    "6651": {"debit": "1783", "credit": "1784"}, "6652": {"debit": "1785", "credit": "1786"}, "668": {"debit": "1787", "credit": "1788"},
    "6681": {"debit": "1789", "credit": "1790"}, "6682": {"debit": "1791", "credit": "1792"}, "6683": {"debit": "1793", "credit": "1794"},
    "6684": {"debit": "1795", "credit": "1796"}, "6688": {"debit": "1797", "credit": "1798"}, "669": {"debit": "1799", "credit": "1800"},
    "67": {"debit": "1801", "credit": "1802"}, "671": {"debit": "1803", "credit": "1804"}, "6711": {"debit": "1805", "credit": "1806"},
    "6712": {"debit": "1807", "credit": "1808"}, "672": {"debit": "1809", "credit": "1810"}, "6721": {"debit": "1811", "credit": "1812"},
    "6722": {"debit": "1813", "credit": "1814"}, "673": {"debit": "1815", "credit": "1816"}, "6731": {"debit": "1817", "credit": "1818"},
    "6732": {"debit": "1819", "credit": "1820"}, "67321": {"debit": "1821", "credit": "1822"}, "67322": {"debit": "1823", "credit": "1824"},
    "6733": {"debit": "1825", "credit": "1826"}, "6738": {"debit": "1827", "credit": "1828"}, "679": {"debit": "1829", "credit": "1830"},
    "6791": {"debit": "1831", "credit": "1832"}, "6792": {"debit": "1833", "credit": "1834"}, "68": {"debit": "1835", "credit": "1836"},
    "681": {"debit": "1837", "credit": "1838"}, "6811": {"debit": "1839", "credit": "1840"}, "6812": {"debit": "1841", "credit": "1842"},
    "682": {"debit": "1843", "credit": "1844"}, "683": {"debit": "1845", "credit": "1846"}, "688": {"debit": "1847", "credit": "1848"},
    "689": {"debit": "1849", "credit": "1850"}, "70": {"debit": "1851", "credit": "1852"}, "701": {"debit": "1853", "credit": "1854"},
    "7011": {"debit": "1855", "credit": "1856"}, "7012": {"debit": "1857", "credit": "1858"}, "7013": {"debit": "1859", "credit": "1860"},
    "702": {"debit": "1861", "credit": "1862"}, "703": {"debit": "1863", "credit": "1864"}, "704": {"debit": "1865", "credit": "1866"},
    "705": {"debit": "1867", "credit": "1868"}, "7051": {"debit": "1869", "credit": "1870"}, "7052": {"debit": "1871", "credit": "1872"},
    "7053": {"debit": "1873", "credit": "1874"}, "706": {"debit": "1875", "credit": "1876"}, "708": {"debit": "1877", "credit": "1878"},
    "7081": {"debit": "1879", "credit": "1880"}, "7082": {"debit": "1881", "credit": "1882"}, "70821": {"debit": "1883", "credit": "1884"},
    "70822": {"debit": "1885", "credit": "1886"}, "7083": {"debit": "1887", "credit": "1888"}, "7088": {"debit": "1889", "credit": "1890"},
    "709": {"debit": "1891", "credit": "1892"}, "7091": {"debit": "1893", "credit": "1894"}, "7092": {"debit": "1895", "credit": "1896"},
    "7093": {"debit": "1897", "credit": "1898"}, "7094": {"debit": "1899", "credit": "1900"}, "7095": {"debit": "1901", "credit": "1902"},
    "7096": {"debit": "1903", "credit": "1904"}, "7098": {"debit": "1905", "credit": "1906"}, "71": {"debit": "1907", "credit": "1908"},
    "711": {"debit": "1909", "credit": "1910"}, "7111": {"debit": "1911", "credit": "1912"}, "7112": {"debit": "1913", "credit": "1914"},
    "7113": {"debit": "1915", "credit": "1916"}, "7114": {"debit": "1917", "credit": "1918"}, "712": {"debit": "1919", "credit": "1920"},
    "7121": {"debit": "1921", "credit": "1922"}, "7122": {"debit": "1923", "credit": "1924"}, "7123": {"debit": "1925", "credit": "1926"},
    "7126": {"debit": "1927", "credit": "1928"}, "7127": {"debit": "1929", "credit": "1930"}, "72": {"debit": "1931", "credit": "1932"},
    "721": {"debit": "1933", "credit": "1934"}, "7211": {"debit": "1935", "credit": "1936"}, "7212": {"debit": "1937", "credit": "1938"},
    "72121": {"debit": "1939", "credit": "1940"}, "72122": {"debit": "1941", "credit": "1942"}, "72123": {"debit": "1943", "credit": "1944"},
    "72124": {"debit": "1945", "credit": "1946"}, "72125": {"debit": "1947", "credit": "1948"}, "721251": {"debit": "1949", "credit": "1950"},
    "721258": {"debit": "1951", "credit": "1952"}, "722": {"debit": "1953", "credit": "1954"}, "7221": {"debit": "1955", "credit": "1956"},
    "7222": {"debit": "1957", "credit": "1958"}, "7223": {"debit": "1959", "credit": "1960"}, "73": {"debit": "1961", "credit": "1962"},
    "732": {"debit": "1963", "credit": "1964"}, "7321": {"debit": "1965", "credit": "1966"}, "7322": {"debit": "1967", "credit": "1968"},
    "7323": {"debit": "1969", "credit": "1970"}, "7324": {"debit": "1971", "credit": "1972"}, "733": {"debit": "1973", "credit": "1974"},
    "7331": {"debit": "1975", "credit": "1976"}, "73311": {"debit": "1977", "credit": "1978"}, "73312": {"debit": "1979", "credit": "1980"},
    "73313": {"debit": "1981", "credit": "1982"}, "73314": {"debit": "1983", "credit": "1984"}, "7332": {"debit": "1985", "credit": "1986"},
    "7333": {"debit": "1987", "credit": "1988"}, "7334": {"debit": "1989", "credit": "1990"}, "734": {"debit": "1991", "credit": "1992"},
    "7341": {"debit": "1993", "credit": "1994"}, "7342": {"debit": "1995", "credit": "1996"}, "7343": {"debit": "1997", "credit": "1998"},
    "7344": {"debit": "1999", "credit": "2000"}, "7345": {"debit": "2001", "credit": "2002"}, "735": {"debit": "2003", "credit": "2004"},
    "7351": {"debit": "2005", "credit": "2006"}, "7352": {"debit": "2007", "credit": "2008"}, "7353": {"debit": "2009", "credit": "2010"},
    "74": {"debit": "2011", "credit": "2012"}, "741": {"debit": "2013", "credit": "2014"}, "7411": {"debit": "2015", "credit": "2016"},
    "7412": {"debit": "2017", "credit": "2018"}, "7413": {"debit": "2019", "credit": "2020"}, "7414": {"debit": "2021", "credit": "2022"},
    "7415": {"debit": "2023", "credit": "2024"}, "74151": {"debit": "2025", "credit": "2026"}, "74158": {"debit": "2027", "credit": "2028"},
    "742": {"debit": "2029", "credit": "2030"}, "743": {"debit": "2031", "credit": "2032"}, "744": {"debit": "2033", "credit": "2034"},
    "7441": {"debit": "2035", "credit": "2036"}, "7442": {"debit": "2037", "credit": "2038"}, "7443": {"debit": "2039", "credit": "2040"},
    "7444": {"debit": "2041", "credit": "2042"}, "74441": {"debit": "2043", "credit": "2044"}, "74442": {"debit": "2045", "credit": "2046"},
    "7448": {"debit": "2047", "credit": "2048"}, "745": {"debit": "2049", "credit": "2050"}, "746": {"debit": "2051", "credit": "2052"},
    "747": {"debit": "2053", "credit": "2054"}, "7471": {"debit": "2055", "credit": "2056"}, "7472": {"debit": "2057", "credit": "2058"},
    "7473": {"debit": "2059", "credit": "2060"}, "748": {"debit": "2061", "credit": "2062"}, "749": {"debit": "2063", "credit": "2064"},
    "75": {"debit": "2065", "credit": "2066"}, "751": {"debit": "2067", "credit": "2068"}, "7511": {"debit": "2069", "credit": "2070"},
    "75111": {"debit": "2071", "credit": "2072"}, "75112": {"debit": "2073", "credit": "2074"}, "75113": {"debit": "2075", "credit": "2076"},
    "75114": {"debit": "2077", "credit": "2078"}, "75115": {"debit": "2079", "credit": "2080"}, "75116": {"debit": "2081", "credit": "2082"},
    "75117": {"debit": "2083", "credit": "2084"}, "7512": {"debit": "2085", "credit": "2086"}, "752": {"debit": "2087", "credit": "2088"},
    "7521": {"debit": "2089", "credit": "2090"}, "7522": {"debit": "2091", "credit": "2092"}, "7523": {"debit": "2093", "credit": "2094"},
    "7524": {"debit": "2095", "credit": "2096"}, "7525": {"debit": "2097", "credit": "2098"}, "7526": {"debit": "2099", "credit": "2100"},
    "7527": {"debit": "2101", "credit": "2102"}, "753": {"debit": "2103", "credit": "2104"}, "7531": {"debit": "2105", "credit": "2106"},
    "7532": {"debit": "2107", "credit": "2108"}, "7533": {"debit": "2109", "credit": "2110"}, "75331": {"debit": "2111", "credit": "2112"},
    "75332": {"debit": "2113", "credit": "2114"}, "75333": {"debit": "2115", "credit": "2116"}, "75338": {"debit": "2117", "credit": "2118"},
    "7534": {"debit": "2119", "credit": "2120"}, "754": {"debit": "2121", "credit": "2122"}, "7541": {"debit": "2123", "credit": "2124"},
    "75411": {"debit": "2125", "credit": "2126"}, "75412": {"debit": "2127", "credit": "2128"}, "75413": {"debit": "2129", "credit": "2130"},
    "75418": {"debit": "2131", "credit": "2132"}, "7548": {"debit": "2133", "credit": "2134"}, "75481": {"debit": "2135", "credit": "2136"},
    "75482": {"debit": "2137", "credit": "2138"}, "75483": {"debit": "2139", "credit": "2140"}, "75488": {"debit": "2141", "credit": "2142"},
    "755": {"debit": "2143", "credit": "2144"}, "7552": {"debit": "2145", "credit": "2146"}, "75521": {"debit": "2147", "credit": "2148"},
    "75522": {"debit": "2149", "credit": "2150"}, "75523": {"debit": "2151", "credit": "2152"}, "7553": {"debit": "2153", "credit": "2154"},
    "7554": {"debit": "2155", "credit": "2156"}, "7555": {"debit": "2157", "credit": "2158"}, "7556": {"debit": "2159", "credit": "2160"},
    "7558": {"debit": "2161", "credit": "2162"}, "756": {"debit": "2163", "credit": "2164"}, "757": {"debit": "2165", "credit": "2166"},
    "758": {"debit": "2167", "credit": "2168"}, "759": {"debit": "2169", "credit": "2170"}, "76": {"debit": "2171", "credit": "2172"},
    "761": {"debit": "2173", "credit": "2174"}, "7611": {"debit": "2175", "credit": "2176"}, "7612": {"debit": "2177", "credit": "2178"},
    "762": {"debit": "2179", "credit": "2180"}, "7621": {"debit": "2181", "credit": "2182"}, "7622": {"debit": "2183", "credit": "2184"},
    "763": {"debit": "2185", "credit": "2186"}, "7631": {"debit": "2187", "credit": "2188"}, "7632": {"debit": "2189", "credit": "2190"},
    "764": {"debit": "2191", "credit": "2192"}, "7641": {"debit": "2193", "credit": "2194"}, "7642": {"debit": "2195", "credit": "2196"},
    "7643": {"debit": "2197", "credit": "2198"}, "7644": {"debit": "2199", "credit": "2200"}, "7645": {"debit": "2201", "credit": "2202"},
    "7646": {"debit": "2203", "credit": "2204"}, "7647": {"debit": "2205", "credit": "2206"}, "765": {"debit": "2207", "credit": "2208"},
    "7651": {"debit": "2209", "credit": "2210"}, "7652": {"debit": "2211", "credit": "2212"}, "768": {"debit": "2213", "credit": "2214"},
    "7681": {"debit": "2215", "credit": "2216"}, "7682": {"debit": "2217", "credit": "2218"}, "7683": {"debit": "2219", "credit": "2220"},
    "7684": {"debit": "2221", "credit": "2222"}, "7685": {"debit": "2223", "credit": "2224"}, "7686": {"debit": "2225", "credit": "2226"},
    "7688": {"debit": "2227", "credit": "2228"}, "769": {"debit": "2229", "credit": "2230"}, "77": {"debit": "2231", "credit": "2232"},
    "771": {"debit": "2233", "credit": "2234"}, "772": {"debit": "2235", "credit": "2236"}, "773": {"debit": "2237", "credit": "2238"},
    "779": {"debit": "2239", "credit": "2240"}, "7791": {"debit": "2241", "credit": "2242"}, "7792": {"debit": "2243", "credit": "2244"},
    "78": {"debit": "2245", "credit": "2246"}, "781": {"debit": "2247", "credit": "2248"}, "782": {"debit": "2249", "credit": "2250"},
    "783": {"debit": "2251", "credit": "2252"}, "788": {"debit": "2253", "credit": "2254"}, "789": {"debit": "2255", "credit": "2256"},
    "1061": {"debit": "2261", "credit": "2262"}, "10611": {"debit": "2263", "credit": "2264"}, "10612": {"debit": "2265", "credit": "2266"},
    "10613": {"debit": "2267", "credit": "2268"}, "10614": {"debit": "2269", "credit": "2270"}, "106141": {"debit": "2271", "credit": "2272"},
    "106142": {"debit": "2273", "credit": "2274"}, "106143": {"debit": "2275", "credit": "2276"}, "106144": {"debit": "2277", "credit": "2278"},
    "106145": {"debit": "2279", "credit": "2280"}, "106148": {"debit": "2281", "credit": "2282"}, "10615": {"debit": "2283", "credit": "2284"},
    "106151": {"debit": "2285", "credit": "2286"}, "106152": {"debit": "2287", "credit": "2288"}, "106153": {"debit": "2289", "credit": "2290"},
    "106154": {"debit": "2291", "credit": "2292"}, "106158": {"debit": "2293", "credit": "2294"}, "10616": {"debit": "2295", "credit": "2296"},
    "106161": {"debit": "2297", "credit": "2298"}, "106162": {"debit": "2299", "credit": "2300"}, "106163": {"debit": "2301", "credit": "2302"},
    "106164": {"debit": "2303", "credit": "2304"}, "106165": {"debit": "2305", "credit": "2306"}, "106166": {"debit": "2307", "credit": "2308"},
    "106168": {"debit": "2309", "credit": "2310"}, "10617": {"debit": "2311", "credit": "2312"}, "106171": {"debit": "2313", "credit": "2314"},
    "106172": {"debit": "2315", "credit": "2316"}, "106173": {"debit": "2317", "credit": "2318"}, "106174": {"debit": "2319", "credit": "2320"},
    "106178": {"debit": "2321", "credit": "2322"}, "10618": {"debit": "2323", "credit": "2324"}, "106181": {"debit": "2325", "credit": "2326"},
    "106182": {"debit": "2327", "credit": "2328"}, "106183": {"debit": "2329", "credit": "2330"}, "106188": {"debit": "2331", "credit": "2332"},
    "10619": {"debit": "2333", "credit": "2334"}, "106191": {"debit": "2335", "credit": "2336"}, "106192": {"debit": "2337", "credit": "2338"},
    "106193": {"debit": "2339", "credit": "2340"}, "106194": {"debit": "2341", "credit": "2342"}, "106195": {"debit": "2343", "credit": "2344"},
    "106198": {"debit": "2345", "credit": "2346"}, "1062": {"debit": "2347", "credit": "2348"}, "10621": {"debit": "2349", "credit": "2350"},
    "10622": {"debit": "2351", "credit": "2352"}, "10623": {"debit": "2353", "credit": "2354"}, "10624": {"debit": "2355", "credit": "2356"},
    "106241": {"debit": "2357", "credit": "2358"}, "106242": {"debit": "2359", "credit": "2360"}, "106243": {"debit": "2361", "credit": "2362"},
    "106244": {"debit": "2363", "credit": "2364"}, "106248": {"debit": "2365", "credit": "2366"}, "10625": {"debit": "2367", "credit": "2368"},
    "10626": {"debit": "2369", "credit": "2370"}, "10627": {"debit": "2371", "credit": "2372"}, "10628": {"debit": "2373", "credit": "2374"},
    "106281": {"debit": "2375", "credit": "2376"}, "106283": {"debit": "2377", "credit": "2378"}, "106284": {"debit": "2379", "credit": "2380"},
    "106288": {"debit": "2381", "credit": "2382"}, "10629": {"debit": "2383", "credit": "2384"}
}

# Built from: https://ecdf-developer.b2g.etat.lu/ecdf/formdocs/2020/CA_PLANCOMPTA/2020M2V004/CA_PLANCOMPTA_LINK_00_DOC_EN_2020M2V004.fieldlist
# The dictionary keys represent the first N digits (with N the lenghts of the code) of the accounts matching the category.
# The dictionary values are themselves a dictionary indicating in which declaration field the debit of the matching accounts
# should be reported ("debit" key), and in which one the credits should be reported ("credit key").
# Based on the LU 2020 Chart of Accounts.
ACCOUNTS_2020 = {
    "10": {"debit": "0101", "credit": "0102"}, "101": {"debit": "0103", "credit": "0104"}, "102": {"debit": "0105", "credit": "0106"},
    "103": {"debit": "0107", "credit": "0108"}, "104": {"debit": "0109", "credit": "0110"}, "105": {"debit": "0115", "credit": "0116"},
    "106": {"debit": "0117", "credit": "0118"}, "11": {"debit": "0119", "credit": "0120"}, "111": {"debit": "0121", "credit": "0122"},
    "112": {"debit": "0123", "credit": "0124"}, "113": {"debit": "0125", "credit": "0126"}, "114": {"debit": "0127", "credit": "0128"},
    "115": {"debit": "0129", "credit": "0130"}, "12": {"debit": "2401", "credit": "2402"}, "122": {"debit": "0135", "credit": "0136"},
    "123": {"debit": "0137", "credit": "0138"}, "128": {"debit": "0139", "credit": "0140"}, "13": {"debit": "2403", "credit": "2404"},
    "131": {"debit": "0143", "credit": "0144"}, "132": {"debit": "0145", "credit": "0146"}, "133": {"debit": "0147", "credit": "0148"},
    "138": {"debit": "2405", "credit": "2406"}, "1381": {"debit": "2407", "credit": "2408"}, "1382": {"debit": "0153", "credit": "0154"},
    "13821": {"debit": "0151", "credit": "0152"}, "13822": {"debit": "0133", "credit": "0134"}, "13823": {"debit": "0175", "credit": "0176"},
    "138231": {"debit": "0177", "credit": "0178"}, "138232": {"debit": "0179", "credit": "0180"}, "13828": {"debit": "2409", "credit": "2410"},
    "14": {"debit": "0157", "credit": "0158", "required": "True"}, "141": {"debit": "0159", "credit": "0160"}, "1411": {"debit": "2411", "credit": "2412"},
    "1412": {"debit": "2413", "credit": "2414"}, "142": {"debit": "2955", "credit": "2956", "required": "True"}, "15": {"debit": "0163", "credit": "0164"},
    "16": {"debit": "2415", "credit": "2416"}, "161": {"debit": "2417", "credit": "2418"}, "1611": {"debit": "2419", "credit": "2420"},
    "1612": {"debit": "2421", "credit": "2422"}, "16121": {"debit": "2423", "credit": "2424"}, "16122": {"debit": "2425", "credit": "2426"},
    "1613": {"debit": "2427", "credit": "2428"}, "162": {"debit": "0165", "credit": "0166"}, "1621": {"debit": "0167", "credit": "0168"},
    "1622": {"debit": "0169", "credit": "0170"}, "1623": {"debit": "0171", "credit": "0172"}, "168": {"debit": "0173", "credit": "0174"},
    "18": {"debit": "0181", "credit": "0182"}, "181": {"debit": "0183", "credit": "0184"}, "182": {"debit": "0185", "credit": "0186"},
    "183": {"debit": "0195", "credit": "0196"}, "188": {"debit": "0197", "credit": "0198"}, "1881": {"debit": "0199", "credit": "0200"},
    "1882": {"debit": "0201", "credit": "0202"}, "19": {"debit": "2429", "credit": "2430"}, "192": {"debit": "0221", "credit": "0222"},
    "1921": {"debit": "0223", "credit": "0224"}, "1922": {"debit": "0229", "credit": "0230"}, "193": {"debit": "0235", "credit": "0236"},
    "1931": {"debit": "0237", "credit": "0238"}, "1932": {"debit": "0243", "credit": "0244"}, "194": {"debit": "0249", "credit": "0250"},
    "1941": {"debit": "0251", "credit": "0252"}, "1942": {"debit": "0257", "credit": "0258"}, "20": {"debit": "0291", "credit": "0292"},
    "201": {"debit": "2431", "credit": "2432"}, "203": {"debit": "0301", "credit": "0302"}, "204": {"debit": "0303", "credit": "0304"},
    "208": {"debit": "0305", "credit": "0306"}, "21": {"debit": "0307", "credit": "0308"}, "211": {"debit": "2433", "credit": "2434"},
    "212": {"debit": "0311", "credit": "0312"}, "2121": {"debit": "0313", "credit": "0314"}, "21211": {"debit": "0315", "credit": "0316"},
    "21212": {"debit": "0317", "credit": "0318"}, "21213": {"debit": "0319", "credit": "0320"}, "21214": {"debit": "0321", "credit": "0322"},
    "21215": {"debit": "0323", "credit": "0324"}, "212151": {"debit": "0325", "credit": "0326"}, "212152": {"debit": "0327", "credit": "0328"},
    "212158": {"debit": "0329", "credit": "0330"}, "2122": {"debit": "0331", "credit": "0332"}, "21221": {"debit": "0333", "credit": "0334"},
    "21222": {"debit": "0335", "credit": "0336"}, "21223": {"debit": "0337", "credit": "0338"}, "21224": {"debit": "0339", "credit": "0340"},
    "21225": {"debit": "0341", "credit": "0342"}, "212251": {"debit": "0343", "credit": "0344"}, "212258": {"debit": "0347", "credit": "0348"},
    "213": {"debit": "0349", "credit": "0350"}, "214": {"debit": "0351", "credit": "0352"}, "22": {"debit": "0359", "credit": "0360"},
    "221": {"debit": "0361", "credit": "0362"}, "2211": {"debit": "0363", "credit": "0364"}, "22111": {"debit": "2435", "credit": "2436"},
    "221111": {"debit": "0373", "credit": "0374"}, "221112": {"debit": "2437", "credit": "2438"}, "221118": {"debit": "2439", "credit": "2440"},
    "22112": {"debit": "2441", "credit": "2442"}, "2212": {"debit": "0377", "credit": "0378"}, "22121": {"debit": "2443", "credit": "2444"},
    "22122": {"debit": "2445", "credit": "2446"}, "2213": {"debit": "0391", "credit": "0392"}, "22131": {"debit": "2447", "credit": "2448"},
    "221311": {"debit": "2449", "credit": "2450"}, "221312": {"debit": "2451", "credit": "2452"}, "221313": {"debit": "2453", "credit": "2454"},
    "221318": {"debit": "2455", "credit": "2456"}, "22132": {"debit": "2457", "credit": "2458"}, "2214": {"debit": "2459", "credit": "2460"},
    "22141": {"debit": "2461", "credit": "2462"}, "22142": {"debit": "2463", "credit": "2464"}, "2215": {"debit": "2465", "credit": "2466"},
    "22151": {"debit": "2467", "credit": "2468"}, "22152": {"debit": "2469", "credit": "2470"}, "222": {"debit": "0397", "credit": "0398"},
    "2221": {"debit": "0399", "credit": "0400"}, "2222": {"debit": "0401", "credit": "0402"}, "223": {"debit": "0403", "credit": "0404"},
    "2231": {"debit": "0405", "credit": "0406"}, "2232": {"debit": "0407", "credit": "0408"}, "2233": {"debit": "0409", "credit": "0410"},
    "2234": {"debit": "0411", "credit": "0412"}, "2235": {"debit": "0413", "credit": "0414"}, "2236": {"debit": "0415", "credit": "0416"},
    "2237": {"debit": "0417", "credit": "0418"}, "2238": {"debit": "0419", "credit": "0420"}, "224": {"debit": "0421", "credit": "0422"},
    "2241": {"debit": "0423", "credit": "0424"}, "22411": {"debit": "2471", "credit": "2472"}, "22412": {"debit": "2473", "credit": "2474"},
    "2242": {"debit": "0431", "credit": "0432"}, "2243": {"debit": "0433", "credit": "0434"}, "23": {"debit": "2475", "credit": "2476"},
    "231": {"debit": "0437", "credit": "0438"}, "232": {"debit": "0439", "credit": "0440"}, "233": {"debit": "0441", "credit": "0442"},
    "234": {"debit": "0443", "credit": "0444"}, "235": {"debit": "0445", "credit": "0446"}, "2351": {"debit": "0447", "credit": "0448"},
    "23511": {"debit": "0449", "credit": "0450"}, "235111": {"debit": "2477", "credit": "2478"}, "235112": {"debit": "2479", "credit": "2480"},
    "23518": {"debit": "0451", "credit": "0452"}, "2352": {"debit": "0453", "credit": "0454"}, "23521": {"debit": "0455", "credit": "0456"},
    "23528": {"debit": "0457", "credit": "0458"}, "2353": {"debit": "2481", "credit": "2482"}, "2358": {"debit": "0459", "credit": "0460"},
    "236": {"debit": "0461", "credit": "0462"}, "2361": {"debit": "0463", "credit": "0464"}, "2362": {"debit": "0473", "credit": "0474"},
    "2363": {"debit": "0479", "credit": "0480"}, "30": {"debit": "0483", "credit": "0484"}, "301": {"debit": "0485", "credit": "0486"},
    "303": {"debit": "2483", "credit": "2484"}, "304": {"debit": "0507", "credit": "0508"}, "31": {"debit": "0517", "credit": "0518"},
    "311": {"debit": "0519", "credit": "0520"}, "312": {"debit": "0521", "credit": "0522"}, "313": {"debit": "0523", "credit": "0524"},
    "314": {"debit": "0525", "credit": "0526"}, "315": {"debit": "2961", "credit": "2962"}, "32": {"debit": "2485", "credit": "2486"},
    "321": {"debit": "0529", "credit": "0530"}, "322": {"debit": "0531", "credit": "0532"}, "323": {"debit": "0533", "credit": "0534"},
    "36": {"debit": "2487", "credit": "2488"}, "361": {"debit": "0541", "credit": "0542"}, "362": {"debit": "0547", "credit": "0548"},
    "3621": {"debit": "2489", "credit": "2490"}, "3622": {"debit": "2491", "credit": "2492"}, "363": {"debit": "0549", "credit": "0550"},
    "3631": {"debit": "2493", "credit": "2494"}, "3632": {"debit": "2495", "credit": "2496"}, "37": {"debit": "0555", "credit": "0556"},
    "40": {"debit": "0565", "credit": "0566"}, "401": {"debit": "0567", "credit": "0568"}, "4011": {"debit": "0569", "credit": "0570"},
    "4012": {"debit": "0571", "credit": "0572"}, "4013": {"debit": "0573", "credit": "0574"}, "4014": {"debit": "0575", "credit": "0576"},
    "4015": {"debit": "0577", "credit": "0578"}, "4019": {"debit": "0579", "credit": "0580"}, "402": {"debit": "0581", "credit": "0582"},
    "4021": {"debit": "0583", "credit": "0584"}, "4025": {"debit": "0591", "credit": "0592"}, "4029": {"debit": "0593", "credit": "0594"},
    "41": {"debit": "0595", "credit": "0596"}, "411": {"debit": "0597", "credit": "0598"}, "4111": {"debit": "0599", "credit": "0600"},
    "41111": {"debit": "0601", "credit": "0602"}, "41112": {"debit": "0603", "credit": "0604"}, "41118": {"debit": "0609", "credit": "0610"},
    "41119": {"debit": "0611", "credit": "0612"}, "4112": {"debit": "0613", "credit": "0614"}, "41121": {"debit": "0615", "credit": "0616"},
    "41122": {"debit": "0617", "credit": "0618"}, "41128": {"debit": "0623", "credit": "0624"}, "41129": {"debit": "0625", "credit": "0626"},
    "412": {"debit": "0627", "credit": "0628"}, "4121": {"debit": "0629", "credit": "0630"}, "41211": {"debit": "0631", "credit": "0632"},
    "41212": {"debit": "0633", "credit": "0634"}, "41218": {"debit": "0639", "credit": "0640"}, "41219": {"debit": "0641", "credit": "0642"},
    "4122": {"debit": "0643", "credit": "0644"}, "41221": {"debit": "0645", "credit": "0646"}, "41222": {"debit": "0647", "credit": "0648"},
    "41228": {"debit": "0653", "credit": "0654"}, "41229": {"debit": "0655", "credit": "0656"}, "42": {"debit": "0657", "credit": "0658"},
    "421": {"debit": "0659", "credit": "0660"}, "4211": {"debit": "0661", "credit": "0662"}, "42111": {"debit": "0663", "credit": "0664"},
    "42119": {"debit": "0665", "credit": "0666"}, "4212": {"debit": "0667", "credit": "0668"}, "4213": {"debit": "0675", "credit": "0676"},
    "42131": {"debit": "0677", "credit": "0678"}, "42132": {"debit": "0679", "credit": "0680"}, "42138": {"debit": "0681", "credit": "0682"},
    "4214": {"debit": "0683", "credit": "0684"}, "42141": {"debit": "2497", "credit": "2498"}, "42142": {"debit": "2499", "credit": "2500"},
    "42143": {"debit": "2501", "credit": "2502"}, "42144": {"debit": "2503", "credit": "2504"}, "42145": {"debit": "2505", "credit": "2506"},
    "42146": {"debit": "2507", "credit": "2508"}, "42148": {"debit": "2509", "credit": "2510"}, "4215": {"debit": "0685", "credit": "0686"},
    "4216": {"debit": "0687", "credit": "0688"}, "42161": {"debit": "0689", "credit": "0690"}, "421611": {"debit": "0691", "credit": "0692"},
    "421612": {"debit": "0693", "credit": "0694"}, "421613": {"debit": "0695", "credit": "0696"}, "421618": {"debit": "0697", "credit": "0698"},
    "42162": {"debit": "0699", "credit": "0700"}, "421621": {"debit": "0701", "credit": "0702"}, "421622": {"debit": "0703", "credit": "0704"},
    "421628": {"debit": "0709", "credit": "0710"}, "42168": {"debit": "0711", "credit": "0712"}, "4217": {"debit": "0713", "credit": "0714"},
    "42171": {"debit": "2511", "credit": "2512"}, "42172": {"debit": "2513", "credit": "2514"}, "42178": {"debit": "0719", "credit": "0720"},
    "4218": {"debit": "0721", "credit": "0722"}, "42181": {"debit": "0723", "credit": "0724"}, "421811": {"debit": "0725", "credit": "0726"},
    "421818": {"debit": "0727", "credit": "0728"}, "42187": {"debit": "2515", "credit": "2516"}, "42188": {"debit": "0729", "credit": "0730"},
    "42189": {"debit": "0731", "credit": "0732"}, "422": {"debit": "0733", "credit": "0734"}, "4221": {"debit": "0735", "credit": "0736"},
    "4222": {"debit": "0741", "credit": "0742"}, "4223": {"debit": "0749", "credit": "0750"}, "42231": {"debit": "0751", "credit": "0752"},
    "42232": {"debit": "0753", "credit": "0754"}, "42238": {"debit": "0755", "credit": "0756"}, "4228": {"debit": "0793", "credit": "0794"},
    "42287": {"debit": "2517", "credit": "2518"}, "42288": {"debit": "0801", "credit": "0802"}, "42289": {"debit": "0803", "credit": "0804"},
    "43": {"debit": "0805", "credit": "0806"}, "431": {"debit": "0807", "credit": "0808"}, "4311": {"debit": "2963", "credit": "2964"},
    "4312": {"debit": "2965", "credit": "2966"}, "432": {"debit": "0809", "credit": "0810"}, "4321": {"debit": "2967", "credit": "2968"},
    "4322": {"debit": "2969", "credit": "2970"}, "44": {"debit": "0811", "credit": "0812"}, "441": {"debit": "0813", "credit": "0814"},
    "4411": {"debit": "0815", "credit": "0816"}, "44111": {"debit": "0817", "credit": "0818"}, "44112": {"debit": "0819", "credit": "0820"},
    "44113": {"debit": "0821", "credit": "0822"}, "4412": {"debit": "0831", "credit": "0832"}, "44121": {"debit": "0833", "credit": "0834"},
    "44123": {"debit": "0837", "credit": "0838"}, "442": {"debit": "0847", "credit": "0848"}, "4421": {"debit": "0849", "credit": "0850"},
    "4422": {"debit": "0851", "credit": "0852"}, "45": {"debit": "0853", "credit": "0854"}, "451": {"debit": "0855", "credit": "0856"},
    "4511": {"debit": "0857", "credit": "0858"}, "45111": {"debit": "0859", "credit": "0860"}, "45112": {"debit": "0861", "credit": "0862"},
    "45118": {"debit": "0867", "credit": "0868"}, "4512": {"debit": "0869", "credit": "0870"}, "45121": {"debit": "0871", "credit": "0872"},
    "45122": {"debit": "0873", "credit": "0874"}, "45128": {"debit": "0879", "credit": "0880"}, "452": {"debit": "0881", "credit": "0882"},
    "4521": {"debit": "0883", "credit": "0884"}, "45211": {"debit": "0885", "credit": "0886"}, "45212": {"debit": "0887", "credit": "0888"},
    "45218": {"debit": "0893", "credit": "0894"}, "4522": {"debit": "0895", "credit": "0896"}, "45221": {"debit": "0897", "credit": "0898"},
    "45222": {"debit": "0899", "credit": "0900"}, "45228": {"debit": "0905", "credit": "0906"}, "46": {"debit": "0907", "credit": "0908"},
    "461": {"debit": "0909", "credit": "0910"}, "4611": {"debit": "0911", "credit": "0912"}, "4612": {"debit": "0917", "credit": "0918"},
    "46121": {"debit": "0919", "credit": "0920"}, "461211": {"debit": "0921", "credit": "0922"}, "461212": {"debit": "0923", "credit": "0924"},
    "46122": {"debit": "0925", "credit": "0926"}, "461221": {"debit": "0927", "credit": "0928"}, "461222": {"debit": "0929", "credit": "0930"},
    "46123": {"debit": "0931", "credit": "0932"}, "461231": {"debit": "0933", "credit": "0934"}, "461232": {"debit": "0935", "credit": "0936"},
    "46124": {"debit": "0937", "credit": "0938"}, "46125": {"debit": "0939", "credit": "0940"}, "46126": {"debit": "0941", "credit": "0942"},
    "46128": {"debit": "0943", "credit": "0944"}, "4613": {"debit": "0945", "credit": "0946"}, "4614": {"debit": "0953", "credit": "0954"},
    "46141": {"debit": "0955", "credit": "0956"}, "461411": {"debit": "0957", "credit": "0958"}, "461412": {"debit": "0959", "credit": "0960"},
    "461413": {"debit": "0961", "credit": "0962"}, "461418": {"debit": "0963", "credit": "0964"}, "46142": {"debit": "0965", "credit": "0966"},
    "461421": {"debit": "0967", "credit": "0968"}, "461422": {"debit": "0969", "credit": "0970"}, "461428": {"debit": "0975", "credit": "0976"},
    "46148": {"debit": "2519", "credit": "2520"}, "4615": {"debit": "0977", "credit": "0978"}, "46151": {"debit": "2521", "credit": "2522"},
    "46158": {"debit": "2523", "credit": "2524"}, "462": {"debit": "0979", "credit": "0980"}, "4621": {"debit": "0981", "credit": "0982"},
    "4622": {"debit": "0983", "credit": "0984"}, "4628": {"debit": "0985", "credit": "0986"}, "47": {"debit": "0987", "credit": "0988"},
    "471": {"debit": "0989", "credit": "0990"}, "4711": {"debit": "0991", "credit": "0992"}, "4712": {"debit": "0999", "credit": "1000"},
    "4713": {"debit": "1005", "credit": "1006"}, "4714": {"debit": "1007", "credit": "1008"}, "4715": {"debit": "1017", "credit": "1018"},
    "4716": {"debit": "0271", "credit": "0272"}, "47161": {"debit": "0273", "credit": "0274"}, "47162": {"debit": "0265", "credit": "0266"},
    "47163": {"debit": "0275", "credit": "0276"}, "47168": {"debit": "0277", "credit": "0278"}, "4717": {"debit": "2525", "credit": "2526"},
    "4718": {"debit": "1019", "credit": "1020"}, "472": {"debit": "1021", "credit": "1022"}, "4721": {"debit": "1023", "credit": "1024"},
    "4722": {"debit": "1031", "credit": "1032"}, "4723": {"debit": "1037", "credit": "1038"}, "4724": {"debit": "1039", "credit": "1040"},
    "4726": {"debit": "0281", "credit": "0282"}, "47261": {"debit": "0283", "credit": "0284"}, "47262": {"debit": "0267", "credit": "0268"},
    "47263": {"debit": "0285", "credit": "0286"}, "47268": {"debit": "0287", "credit": "0288"}, "4727": {"debit": "2527", "credit": "2528"},
    "4728": {"debit": "1051", "credit": "1052"}, "48": {"debit": "1053", "credit": "1054"}, "481": {"debit": "1055", "credit": "1056"},
    "482": {"debit": "1057", "credit": "1058"}, "483": {"debit": "1059", "credit": "1060"}, "484": {"debit": "1061", "credit": "1062"},
    "485": {"debit": "1063", "credit": "1064"}, "486": {"debit": "1065", "credit": "1066"}, "487": {"debit": "1067", "credit": "1068"},
    "50": {"debit": "2529", "credit": "2530"}, "501": {"debit": "1071", "credit": "1072"}, "502": {"debit": "1075", "credit": "1076"},
    "503": {"debit": "1073", "credit": "1074"}, "508": {"debit": "1077", "credit": "1078"}, "5081": {"debit": "1079", "credit": "1080"},
    "5082": {"debit": "1081", "credit": "1082"}, "5083": {"debit": "1083", "credit": "1084"}, "5084": {"debit": "1085", "credit": "1086"},
    "5085": {"debit": "1087", "credit": "1088"}, "5088": {"debit": "1089", "credit": "1090"}, "51": {"debit": "1091", "credit": "1092"},
    "513": {"debit": "2531", "credit": "2532"}, "5131": {"debit": "2533", "credit": "2534"}, "5132": {"debit": "2535", "credit": "2536"},
    "516": {"debit": "1105", "credit": "1106"}, "517": {"debit": "1107", "credit": "1108"}, "5171": {"debit": "2537", "credit": "2538"},
    "5172": {"debit": "2539", "credit": "2540"}, "518": {"debit": "1109", "credit": "1110"}, "60": {"debit": "1113", "credit": "1114"},
    "601": {"debit": "1115", "credit": "1116"}, "603": {"debit": "2541", "credit": "2542"}, "6031": {"debit": "1121", "credit": "1122"},
    "60311": {"debit": "1123", "credit": "1124"}, "60312": {"debit": "1125", "credit": "1126"}, "60313": {"debit": "1127", "credit": "1128"},
    "60314": {"debit": "2543", "credit": "2544"}, "60315": {"debit": "1183", "credit": "1184"}, "6032": {"debit": "2545", "credit": "2546"},
    "6033": {"debit": "2547", "credit": "2548"}, "6034": {"debit": "2549", "credit": "2550"}, "6035": {"debit": "1135", "credit": "1136"},
    "6036": {"debit": "1137", "credit": "1138"}, "6037": {"debit": "1139", "credit": "1140"}, "6038": {"debit": "1141", "credit": "1142"},
    "604": {"debit": "1143", "credit": "1144"}, "606": {"debit": "1153", "credit": "1154"}, "6061": {"debit": "1159", "credit": "1160"},
    "6062": {"debit": "1155", "credit": "1156"}, "6063": {"debit": "1157", "credit": "1158"}, "607": {"debit": "1161", "credit": "1162"},
    "6071": {"debit": "1163", "credit": "1164"}, "6073": {"debit": "2551", "credit": "2552"}, "6074": {"debit": "1169", "credit": "1170"},
    "6076": {"debit": "1173", "credit": "1174"}, "60761": {"debit": "2553", "credit": "2554"}, "60762": {"debit": "2555", "credit": "2556"},
    "60763": {"debit": "2557", "credit": "2558"}, "608": {"debit": "1199", "credit": "1200"}, "6081": {"debit": "1201", "credit": "1202"},
    "60811": {"debit": "1203", "credit": "1204"}, "60812": {"debit": "1205", "credit": "1206"}, "60813": {"debit": "1207", "credit": "1208"},
    "60814": {"debit": "2559", "credit": "2560"}, "6082": {"debit": "1209", "credit": "1210"}, "6083": {"debit": "2561", "credit": "2562"},
    "6088": {"debit": "1211", "credit": "1212"}, "609": {"debit": "1213", "credit": "1214"}, "6091": {"debit": "1215", "credit": "1216"},
    "6093": {"debit": "2563", "credit": "2564"}, "6094": {"debit": "1221", "credit": "1222"}, "6096": {"debit": "2565", "credit": "2566"},
    "6098": {"debit": "1227", "credit": "1228"}, "6099": {"debit": "1229", "credit": "1230"}, "61": {"debit": "1231", "credit": "1232"},
    "611": {"debit": "1233", "credit": "1234"}, "6111": {"debit": "2567", "credit": "2568"}, "61111": {"debit": "2569", "credit": "2570"},
    "61112": {"debit": "2571", "credit": "2572"}, "6112": {"debit": "2573", "credit": "2574"}, "61123": {"debit": "1247", "credit": "1248"},
    "61128": {"debit": "2575", "credit": "2576"}, "6113": {"debit": "1249", "credit": "1250"}, "6114": {"debit": "2577", "credit": "2578"},
    "6115": {"debit": "2579", "credit": "2580"}, "61153": {"debit": "1263", "credit": "1264"}, "61158": {"debit": "2581", "credit": "2582"},
    "612": {"debit": "1267", "credit": "1268"}, "6121": {"debit": "1269", "credit": "1270"}, "6122": {"debit": "2583", "credit": "2584"},
    "61221": {"debit": "2585", "credit": "2586"}, "61223": {"debit": "1277", "credit": "1278"}, "61228": {"debit": "2587", "credit": "2588"},
    "613": {"debit": "1283", "credit": "1284"}, "6131": {"debit": "1285", "credit": "1286"}, "6132": {"debit": "1293", "credit": "1294"},
    "6133": {"debit": "1295", "credit": "1296"}, "61332": {"debit": "2589", "credit": "2590"}, "61333": {"debit": "2591", "credit": "2592"},
    "61334": {"debit": "1303", "credit": "1304"}, "61336": {"debit": "1307", "credit": "1308"}, "61338": {"debit": "2593", "credit": "2594"},
    "6134": {"debit": "2595", "credit": "2596"}, "61341": {"debit": "2597", "credit": "2598"}, "61342": {"debit": "2599", "credit": "2600"},
    "61348": {"debit": "1321", "credit": "1322"}, "6135": {"debit": "2601", "credit": "2602"}, "6138": {"debit": "1327", "credit": "1328"},
    "614": {"debit": "1329", "credit": "1330"}, "6141": {"debit": "1331", "credit": "1332"}, "61411": {"debit": "1333", "credit": "1334"},
    "61412": {"debit": "1335", "credit": "1336"}, "61418": {"debit": "2603", "credit": "2604"}, "6142": {"debit": "1341", "credit": "1342"},
    "6143": {"debit": "1343", "credit": "1344"}, "6144": {"debit": "1351", "credit": "1352"}, "6145": {"debit": "1353", "credit": "1354"},
    "6146": {"debit": "1355", "credit": "1356"}, "6148": {"debit": "1357", "credit": "1358"}, "615": {"debit": "1359", "credit": "1360"},
    "6151": {"debit": "1361", "credit": "1362"}, "61511": {"debit": "1363", "credit": "1364"}, "61512": {"debit": "1365", "credit": "1366"},
    "61513": {"debit": "1367", "credit": "1368"}, "61514": {"debit": "1369", "credit": "1370"}, "61515": {"debit": "1371", "credit": "1372"},
    "61516": {"debit": "1373", "credit": "1374"}, "61517": {"debit": "1375", "credit": "1376"}, "61518": {"debit": "1377", "credit": "1378"},
    "6152": {"debit": "1379", "credit": "1380"}, "61521": {"debit": "1381", "credit": "1382"}, "615211": {"debit": "1383", "credit": "1384"},
    "615212": {"debit": "1385", "credit": "1386"}, "61522": {"debit": "1387", "credit": "1388"}, "61523": {"debit": "1389", "credit": "1390"},
    "61524": {"debit": "1391", "credit": "1392"}, "6153": {"debit": "1393", "credit": "1394"}, "61531": {"debit": "1395", "credit": "1396"},
    "61532": {"debit": "1397", "credit": "1398"}, "616": {"debit": "1401", "credit": "1402"}, "6161": {"debit": "1403", "credit": "1404"},
    "6162": {"debit": "1405", "credit": "1406"}, "6165": {"debit": "1411", "credit": "1412"}, "6168": {"debit": "2605", "credit": "2606"},
    "617": {"debit": "1415", "credit": "1416"}, "6171": {"debit": "1417", "credit": "1418"}, "6172": {"debit": "1419", "credit": "1420"},
    "618": {"debit": "1421", "credit": "1422"}, "6181": {"debit": "1423", "credit": "1424"}, "6182": {"debit": "1429", "credit": "1430"},
    "6183": {"debit": "2953", "credit": "2954"}, "6184": {"debit": "2607", "credit": "2608"}, "61841": {"debit": "2609", "credit": "2610"},
    "61842": {"debit": "2611", "credit": "2612"}, "61843": {"debit": "1185", "credit": "1186"}, "61844": {"debit": "2613", "credit": "2614"},
    "61845": {"debit": "2615", "credit": "2616"}, "6185": {"debit": "1187", "credit": "1188"}, "61851": {"debit": "1189", "credit": "1190"},
    "61852": {"debit": "2617", "credit": "2618"}, "61853": {"debit": "2619", "credit": "2620"}, "61854": {"debit": "2621", "credit": "2622"},
    "61858": {"debit": "2623", "credit": "2624"}, "6186": {"debit": "1437", "credit": "1438"}, "6187": {"debit": "1439", "credit": "1440"},
    "6188": {"debit": "1441", "credit": "1442"}, "619": {"debit": "1443", "credit": "1444"}, "62": {"debit": "1445", "credit": "1446"},
    "621": {"debit": "1447", "credit": "1448"}, "6211": {"debit": "1449", "credit": "1450"}, "62111": {"debit": "1451", "credit": "1452"},
    "62112": {"debit": "1453", "credit": "1454"}, "621121": {"debit": "1455", "credit": "1456"}, "621122": {"debit": "1457", "credit": "1458"},
    "621123": {"debit": "1459", "credit": "1460"}, "621128": {"debit": "1461", "credit": "1462"}, "62114": {"debit": "1465", "credit": "1466"},
    "62115": {"debit": "1467", "credit": "1468"}, "62116": {"debit": "1469", "credit": "1470"}, "62117": {"debit": "1471", "credit": "1472"},
    "6218": {"debit": "2625", "credit": "2626"}, "6219": {"debit": "1475", "credit": "1476"}, "622": {"debit": "1483", "credit": "1484"},
    "6221": {"debit": "1485", "credit": "1486"}, "6222": {"debit": "1487", "credit": "1488"}, "6228": {"debit": "1489", "credit": "1490"},
    "623": {"debit": "1491", "credit": "1492"}, "6231": {"debit": "2627", "credit": "2628"}, "6232": {"debit": "2629", "credit": "2630"},
    "624": {"debit": "2631", "credit": "2632"}, "6241": {"debit": "1509", "credit": "1510"}, "62411": {"debit": "1511", "credit": "1512"},
    "62412": {"debit": "1513", "credit": "1514"}, "62413": {"debit": "1515", "credit": "1516"}, "62414": {"debit": "1517", "credit": "1518"},
    "62415": {"debit": "1519", "credit": "1520"}, "6248": {"debit": "2633", "credit": "2634"}, "63": {"debit": "1527", "credit": "1528"},
    "631": {"debit": "1529", "credit": "1530"}, "6311": {"debit": "2635", "credit": "2636"}, "6313": {"debit": "1535", "credit": "1536"},
    "6314": {"debit": "1537", "credit": "1538"}, "6318": {"debit": "1539", "credit": "1540"}, "632": {"debit": "1541", "credit": "1542"},
    "6321": {"debit": "2637", "credit": "2638"}, "6322": {"debit": "1545", "credit": "1546"}, "6323": {"debit": "1547", "credit": "1548"},
    "6324": {"debit": "1549", "credit": "1550"}, "633": {"debit": "1551", "credit": "1552"}, "6331": {"debit": "1553", "credit": "1554"},
    "63311": {"debit": "1555", "credit": "1556"}, "63312": {"debit": "1557", "credit": "1558"}, "63313": {"debit": "1559", "credit": "1560"},
    "63314": {"debit": "2639", "credit": "2640"}, "63315": {"debit": "2641", "credit": "2642"}, "6332": {"debit": "1561", "credit": "1562"},
    "6333": {"debit": "1563", "credit": "1564"}, "6334": {"debit": "1565", "credit": "1566"}, "634": {"debit": "1567", "credit": "1568"},
    "6341": {"debit": "1569", "credit": "1570"}, "6342": {"debit": "1571", "credit": "1572"}, "6343": {"debit": "1573", "credit": "1574"},
    "6344": {"debit": "1575", "credit": "1576"}, "6345": {"debit": "1577", "credit": "1578"}, "635": {"debit": "1579", "credit": "1580"},
    "6351": {"debit": "1581", "credit": "1582"}, "6352": {"debit": "1583", "credit": "1584"}, "6353": {"debit": "1585", "credit": "1586"},
    "6354": {"debit": "2643", "credit": "2644"}, "64": {"debit": "1587", "credit": "1588"}, "641": {"debit": "1589", "credit": "1590"},
    "6411": {"debit": "1591", "credit": "1592"}, "6412": {"debit": "1593", "credit": "1594"}, "6413": {"debit": "1595", "credit": "1596"},
    "6414": {"debit": "1597", "credit": "1598"}, "6415": {"debit": "1599", "credit": "1600"}, "64151": {"debit": "1601", "credit": "1602"},
    "64158": {"debit": "1603", "credit": "1604"}, "642": {"debit": "2645", "credit": "2646"}, "643": {"debit": "2647", "credit": "2648"},
    "6431": {"debit": "1607", "credit": "1608"}, "6432": {"debit": "1609", "credit": "1610"}, "6438": {"debit": "2649", "credit": "2650"},
    "644": {"debit": "2651", "credit": "2652"}, "6441": {"debit": "2653", "credit": "2654"}, "64411": {"debit": "2655", "credit": "2656"},
    "64412": {"debit": "2657", "credit": "2658"}, "6442": {"debit": "2659", "credit": "2660"}, "64421": {"debit": "1763", "credit": "1764"},
    "64422": {"debit": "2661", "credit": "2662"}, "645": {"debit": "1611", "credit": "1612"}, "6451": {"debit": "1613", "credit": "1614"},
    "6452": {"debit": "2663", "credit": "2664"}, "6453": {"debit": "2665", "credit": "2666"}, "6454": {"debit": "1617", "credit": "1618"},
    "646": {"debit": "1619", "credit": "1620"}, "6461": {"debit": "1621", "credit": "1622"}, "6462": {"debit": "1623", "credit": "1624"},
    "6463": {"debit": "1625", "credit": "1626"}, "6464": {"debit": "1633", "credit": "1634"}, "6465": {"debit": "1635", "credit": "1636"},
    "64651": {"debit": "1637", "credit": "1638"}, "64658": {"debit": "2667", "credit": "2668"}, "6466": {"debit": "1647", "credit": "1648"},
    "6467": {"debit": "1649", "credit": "1650"}, "6468": {"debit": "1651", "credit": "1652"}, "647": {"debit": "1655", "credit": "1656"},
    "648": {"debit": "2669", "credit": "2670"}, "6481": {"debit": "1791", "credit": "1792"}, "6488": {"debit": "2671", "credit": "2672"},
    "649": {"debit": "2673", "credit": "2674"}, "6491": {"debit": "1653", "credit": "1654"}, "6492": {"debit": "1659", "credit": "1660"},
    "65": {"debit": "1661", "credit": "1662"}, "651": {"debit": "1663", "credit": "1664"}, "6511": {"debit": "1665", "credit": "1666"},
    "65111": {"debit": "1667", "credit": "1668"}, "65112": {"debit": "1669", "credit": "1670"}, "65113": {"debit": "1671", "credit": "1672"},
    "65114": {"debit": "1673", "credit": "1674"}, "65115": {"debit": "1675", "credit": "1676"}, "65116": {"debit": "1677", "credit": "1678"},
    "6512": {"debit": "1681", "credit": "1682"}, "652": {"debit": "2675", "credit": "2676"}, "6521": {"debit": "2677", "credit": "2678"},
    "65211": {"debit": "2679", "credit": "2680"}, "65212": {"debit": "2681", "credit": "2682"}, "65213": {"debit": "2683", "credit": "2684"},
    "65214": {"debit": "2685", "credit": "2686"}, "65215": {"debit": "2687", "credit": "2688"}, "65216": {"debit": "2689", "credit": "2690"},
    "6522": {"debit": "2691", "credit": "2692"}, "65221": {"debit": "2693", "credit": "2694"}, "652211": {"debit": "2695", "credit": "2696"},
    "652212": {"debit": "2697", "credit": "2698"}, "65222": {"debit": "2699", "credit": "2700"}, "652221": {"debit": "2701", "credit": "2702"},
    "652222": {"debit": "2703", "credit": "2704"}, "65223": {"debit": "2705", "credit": "2706"}, "652231": {"debit": "2707", "credit": "2708"},
    "652232": {"debit": "2709", "credit": "2710"}, "65224": {"debit": "2711", "credit": "2712"}, "652241": {"debit": "2713", "credit": "2714"},
    "652242": {"debit": "2715", "credit": "2716"}, "65225": {"debit": "2717", "credit": "2718"}, "652251": {"debit": "2719", "credit": "2720"},
    "652252": {"debit": "2721", "credit": "2722"}, "65226": {"debit": "2723", "credit": "2724"}, "652261": {"debit": "2725", "credit": "2726"},
    "652262": {"debit": "2727", "credit": "2728"}, "653": {"debit": "2729", "credit": "2730"}, "6531": {"debit": "1685", "credit": "1686"},
    "65311": {"debit": "1687", "credit": "1688"}, "65312": {"debit": "1691", "credit": "1692"}, "65313": {"debit": "1689", "credit": "1690"},
    "65318": {"debit": "1693", "credit": "1694"}, "6532": {"debit": "2731", "credit": "2732"}, "654": {"debit": "2733", "credit": "2734"},
    "6541": {"debit": "2735", "credit": "2736"}, "65411": {"debit": "2737", "credit": "2738"}, "65412": {"debit": "2739", "credit": "2740"},
    "65413": {"debit": "2741", "credit": "2742"}, "6542": {"debit": "1701", "credit": "1702"}, "65421": {"debit": "1703", "credit": "1704"},
    "65422": {"debit": "1707", "credit": "1708"}, "65423": {"debit": "1705", "credit": "1706"}, "65428": {"debit": "1709", "credit": "1710"},
    "655": {"debit": "1711", "credit": "1712"}, "6551": {"debit": "1717", "credit": "1718"}, "65511": {"debit": "2743", "credit": "2744"},
    "65512": {"debit": "2745", "credit": "2746"}, "6552": {"debit": "1719", "credit": "1720"}, "65521": {"debit": "1721", "credit": "1722"},
    "65522": {"debit": "1723", "credit": "1724"}, "65523": {"debit": "1725", "credit": "1726"}, "655231": {"debit": "2747", "credit": "2748"},
    "655232": {"debit": "2749", "credit": "2750"}, "6553": {"debit": "1727", "credit": "1728"}, "6554": {"debit": "1729", "credit": "1730"},
    "65541": {"debit": "2751", "credit": "2752"}, "65542": {"debit": "2753", "credit": "2754"}, "6555": {"debit": "1731", "credit": "1732"},
    "65551": {"debit": "2755", "credit": "2756"}, "65552": {"debit": "2757", "credit": "2758"}, "6556": {"debit": "1733", "credit": "1734"},
    "65561": {"debit": "2759", "credit": "2760"}, "65562": {"debit": "2761", "credit": "2762"}, "6558": {"debit": "1735", "credit": "1736"},
    "65581": {"debit": "2763", "credit": "2764"}, "65582": {"debit": "2765", "credit": "2766"}, "656": {"debit": "1737", "credit": "1738"},
    "6561": {"debit": "2767", "credit": "2768"}, "6562": {"debit": "2769", "credit": "2770"}, "657": {"debit": "1739", "credit": "1740"},
    "658": {"debit": "1741", "credit": "1742"}, "6581": {"debit": "2771", "credit": "2772"}, "6582": {"debit": "2773", "credit": "2774"},
    "659": {"debit": "1743", "credit": "1744"}, "6591": {"debit": "2775", "credit": "2776"}, "6592": {"debit": "2777", "credit": "2778"},
    "67": {"debit": "1801", "credit": "1802"}, "671": {"debit": "1803", "credit": "1804"}, "6711": {"debit": "1805", "credit": "1806"},
    "6712": {"debit": "1807", "credit": "1808"}, "672": {"debit": "1809", "credit": "1810"}, "6721": {"debit": "1811", "credit": "1812"},
    "6722": {"debit": "1813", "credit": "1814"}, "673": {"debit": "1815", "credit": "1816"}, "6731": {"debit": "1817", "credit": "1818"},
    "6732": {"debit": "1819", "credit": "1820"}, "67321": {"debit": "1821", "credit": "1822"}, "67322": {"debit": "1823", "credit": "1824"},
    "6733": {"debit": "1825", "credit": "1826"}, "6738": {"debit": "1827", "credit": "1828"}, "679": {"debit": "1829", "credit": "1830"},
    "68": {"debit": "1835", "credit": "1836"}, "681": {"debit": "1837", "credit": "1838"}, "6811": {"debit": "1839", "credit": "1840"},
    "6812": {"debit": "1841", "credit": "1842"}, "682": {"debit": "1843", "credit": "1844"}, "683": {"debit": "1845", "credit": "1846"},
    "688": {"debit": "1847", "credit": "1848"}, "70": {"debit": "1851", "credit": "1852"}, "702": {"debit": "2779", "credit": "2780"},
    "7021": {"debit": "1861", "credit": "1862"}, "7022": {"debit": "1863", "credit": "1864"}, "7023": {"debit": "1865", "credit": "1866"},
    "7029": {"debit": "2781", "credit": "2782"}, "703": {"debit": "2783", "credit": "2784"}, "7031": {"debit": "2785", "credit": "2786"},
    "70311": {"debit": "2787", "credit": "2788"}, "70312": {"debit": "2789", "credit": "2790"}, "70313": {"debit": "2791", "credit": "2792"},
    "70314": {"debit": "2793", "credit": "2794"}, "70315": {"debit": "2795", "credit": "2796"}, "703151": {"debit": "2797", "credit": "2798"},
    "703158": {"debit": "2799", "credit": "2800"}, "7032": {"debit": "1881", "credit": "1882"}, "70321": {"debit": "1883", "credit": "1884"},
    "70322": {"debit": "1885", "credit": "1886"}, "7033": {"debit": "1875", "credit": "1876"}, "7039": {"debit": "2801", "credit": "2802"},
    "704": {"debit": "1887", "credit": "1888"}, "705": {"debit": "1879", "credit": "1880"}, "706": {"debit": "1867", "credit": "1868"},
    "7061": {"debit": "1869", "credit": "1870"}, "7062": {"debit": "2803", "credit": "2804"}, "7063": {"debit": "2805", "credit": "2806"},
    "708": {"debit": "1877", "credit": "1878"}, "709": {"debit": "1891", "credit": "1892"}, "7092": {"debit": "2807", "credit": "2808"},
    "7093": {"debit": "1903", "credit": "1904"}, "7094": {"debit": "2809", "credit": "2810"}, "7095": {"debit": "2811", "credit": "2812"},
    "7096": {"debit": "1901", "credit": "1902"}, "7098": {"debit": "1905", "credit": "1906"}, "7099": {"debit": "2813", "credit": "2814"},
    "71": {"debit": "1907", "credit": "1908"}, "711": {"debit": "1909", "credit": "1910"}, "7111": {"debit": "1911", "credit": "1912"},
    "7112": {"debit": "1913", "credit": "1914"}, "7113": {"debit": "1915", "credit": "1916"}, "7114": {"debit": "1917", "credit": "1918"},
    "712": {"debit": "1919", "credit": "1920"}, "7121": {"debit": "1921", "credit": "1922"}, "7122": {"debit": "1923", "credit": "1924"},
    "7123": {"debit": "1925", "credit": "1926"}, "72": {"debit": "1931", "credit": "1932"}, "721": {"debit": "1933", "credit": "1934"},
    "7211": {"debit": "1935", "credit": "1936"}, "7212": {"debit": "1937", "credit": "1938"}, "72121": {"debit": "1939", "credit": "1940"},
    "72122": {"debit": "1941", "credit": "1942"}, "72123": {"debit": "1943", "credit": "1944"}, "72124": {"debit": "1945", "credit": "1946"},
    "72125": {"debit": "1947", "credit": "1948"}, "721251": {"debit": "1949", "credit": "1950"}, "721258": {"debit": "1951", "credit": "1952"},
    "722": {"debit": "1953", "credit": "1954"}, "7221": {"debit": "1955", "credit": "1956"}, "7222": {"debit": "1957", "credit": "1958"},
    "7223": {"debit": "1959", "credit": "1960"}, "73": {"debit": "1961", "credit": "1962"}, "732": {"debit": "1963", "credit": "1964"},
    "7321": {"debit": "1965", "credit": "1966"}, "7322": {"debit": "1967", "credit": "1968"}, "7324": {"debit": "1971", "credit": "1972"},
    "733": {"debit": "1973", "credit": "1974"}, "7331": {"debit": "1975", "credit": "1976"}, "73311": {"debit": "1977", "credit": "1978"},
    "73312": {"debit": "1979", "credit": "1980"}, "73313": {"debit": "1981", "credit": "1982"}, "73314": {"debit": "2815", "credit": "2816"},
    "73315": {"debit": "2817", "credit": "2818"}, "7332": {"debit": "1985", "credit": "1986"}, "7333": {"debit": "1987", "credit": "1988"},
    "7334": {"debit": "1989", "credit": "1990"}, "734": {"debit": "1991", "credit": "1992"}, "7341": {"debit": "1993", "credit": "1994"},
    "7342": {"debit": "1995", "credit": "1996"}, "7343": {"debit": "1997", "credit": "1998"}, "7344": {"debit": "1999", "credit": "2000"},
    "7345": {"debit": "2001", "credit": "2002"}, "735": {"debit": "2003", "credit": "2004"}, "7351": {"debit": "2005", "credit": "2006"},
    "7352": {"debit": "2007", "credit": "2008"}, "7353": {"debit": "2009", "credit": "2010"}, "7354": {"debit": "2819", "credit": "2820"},
    "74": {"debit": "2011", "credit": "2012"}, "741": {"debit": "2013", "credit": "2014"}, "7411": {"debit": "2015", "credit": "2016"},
    "7412": {"debit": "2017", "credit": "2018"}, "7413": {"debit": "2019", "credit": "2020"}, "7414": {"debit": "2021", "credit": "2022"},
    "7415": {"debit": "2023", "credit": "2024"}, "74151": {"debit": "2025", "credit": "2026"}, "74158": {"debit": "2027", "credit": "2028"},
    "742": {"debit": "2821", "credit": "2822"}, "7421": {"debit": "2823", "credit": "2824"}, "7422": {"debit": "2825", "credit": "2826"},
    "743": {"debit": "2031", "credit": "2032"}, "744": {"debit": "2827", "credit": "2828"}, "7441": {"debit": "2829", "credit": "2830"},
    "74411": {"debit": "2831", "credit": "2832"}, "74412": {"debit": "2833", "credit": "2834"}, "7442": {"debit": "2835", "credit": "2836"},
    "74421": {"debit": "2837", "credit": "2838"}, "74422": {"debit": "2839", "credit": "2840"}, "745": {"debit": "2033", "credit": "2034"},
    "7451": {"debit": "2035", "credit": "2036"}, "7452": {"debit": "2037", "credit": "2038"}, "7453": {"debit": "2039", "credit": "2040"},
    "7454": {"debit": "2041", "credit": "2042"}, "7458": {"debit": "2047", "credit": "2048"}, "746": {"debit": "2841", "credit": "2842"},
    "747": {"debit": "2053", "credit": "2054"}, "7471": {"debit": "2055", "credit": "2056"}, "7472": {"debit": "2057", "credit": "2058"},
    "7473": {"debit": "2059", "credit": "2060"}, "748": {"debit": "2843", "credit": "2844"}, "7481": {"debit": "2051", "credit": "2052"},
    "7488": {"debit": "2845", "credit": "2846"}, "749": {"debit": "2847", "credit": "2848"}, "7491": {"debit": "2849", "credit": "2850"},
    "7492": {"debit": "2063", "credit": "2064"}, "75": {"debit": "2065", "credit": "2066"}, "751": {"debit": "2067", "credit": "2068"},
    "7511": {"debit": "2069", "credit": "2070"}, "75111": {"debit": "2071", "credit": "2072"}, "75112": {"debit": "2073", "credit": "2074"},
    "75113": {"debit": "2075", "credit": "2076"}, "75114": {"debit": "2077", "credit": "2078"}, "75115": {"debit": "2079", "credit": "2080"},
    "75116": {"debit": "2081", "credit": "2082"}, "7512": {"debit": "2085", "credit": "2086"}, "752": {"debit": "2851", "credit": "2852"},
    "7521": {"debit": "2087", "credit": "2088"}, "75211": {"debit": "2089", "credit": "2090"}, "75212": {"debit": "2091", "credit": "2092"},
    "75213": {"debit": "2093", "credit": "2094"}, "75214": {"debit": "2095", "credit": "2096"}, "75215": {"debit": "2097", "credit": "2098"},
    "75216": {"debit": "2099", "credit": "2100"}, "7522": {"debit": "2853", "credit": "2854"}, "75221": {"debit": "2855", "credit": "2856"},
    "752211": {"debit": "2857", "credit": "2858"}, "752212": {"debit": "2859", "credit": "2860"}, "75222": {"debit": "2861", "credit": "2862"},
    "752221": {"debit": "2863", "credit": "2864"}, "752222": {"debit": "2865", "credit": "2866"}, "75223": {"debit": "2867", "credit": "2868"},
    "752231": {"debit": "2869", "credit": "2870"}, "752232": {"debit": "2871", "credit": "2872"}, "75224": {"debit": "2873", "credit": "2874"},
    "752241": {"debit": "2875", "credit": "2876"}, "752242": {"debit": "2877", "credit": "2878"}, "75225": {"debit": "2879", "credit": "2880"},
    "752251": {"debit": "2881", "credit": "2882"}, "752252": {"debit": "2883", "credit": "2884"}, "75226": {"debit": "2885", "credit": "2886"},
    "752261": {"debit": "2887", "credit": "2888"}, "752262": {"debit": "2889", "credit": "2890"}, "753": {"debit": "2891", "credit": "2892"},
    "7531": {"debit": "2109", "credit": "2110"}, "75311": {"debit": "2111", "credit": "2112"}, "75312": {"debit": "2115", "credit": "2116"},
    "75313": {"debit": "2113", "credit": "2114"}, "75318": {"debit": "2117", "credit": "2118"}, "7532": {"debit": "2893", "credit": "2894"},
    "754": {"debit": "2895", "credit": "2896"}, "7541": {"debit": "2897", "credit": "2898"}, "75411": {"debit": "2899", "credit": "2900"},
    "75412": {"debit": "2901", "credit": "2902"}, "75413": {"debit": "2903", "credit": "2904"}, "7542": {"debit": "2123", "credit": "2124"},
    "75421": {"debit": "2125", "credit": "2126"}, "75422": {"debit": "2129", "credit": "2130"}, "75423": {"debit": "2127", "credit": "2128"},
    "75428": {"debit": "2131", "credit": "2132"}, "7548": {"debit": "2133", "credit": "2134"}, "75481": {"debit": "2135", "credit": "2136"},
    "75482": {"debit": "2139", "credit": "2140"}, "75483": {"debit": "2137", "credit": "2138"}, "75488": {"debit": "2141", "credit": "2142"},
    "755": {"debit": "2143", "credit": "2144"}, "7552": {"debit": "2145", "credit": "2146"}, "75521": {"debit": "2905", "credit": "2906"},
    "75523": {"debit": "2151", "credit": "2152"}, "755231": {"debit": "2907", "credit": "2908"}, "755232": {"debit": "2909", "credit": "2910"},
    "7553": {"debit": "2153", "credit": "2154"}, "7554": {"debit": "2155", "credit": "2156"}, "75541": {"debit": "2911", "credit": "2912"},
    "75542": {"debit": "2913", "credit": "2914"}, "7555": {"debit": "2157", "credit": "2158"}, "75551": {"debit": "2915", "credit": "2916"},
    "75552": {"debit": "2917", "credit": "2918"}, "7556": {"debit": "2159", "credit": "2160"}, "75561": {"debit": "2919", "credit": "2920"},
    "75562": {"debit": "2921", "credit": "2922"}, "7558": {"debit": "2161", "credit": "2162"}, "75581": {"debit": "2923", "credit": "2924"},
    "75582": {"debit": "2925", "credit": "2926"}, "756": {"debit": "2163", "credit": "2164"}, "7561": {"debit": "2927", "credit": "2928"},
    "7562": {"debit": "2929", "credit": "2930"}, "757": {"debit": "2165", "credit": "2166"}, "758": {"debit": "2167", "credit": "2168"},
    "7581": {"debit": "2931", "credit": "2932"}, "7582": {"debit": "2933", "credit": "2934"}, "759": {"debit": "2169", "credit": "2170"},
    "7591": {"debit": "2935", "credit": "2936"}, "7592": {"debit": "2937", "credit": "2938"}, "77": {"debit": "2231", "credit": "2232"},
    "771": {"debit": "2233", "credit": "2234"}, "772": {"debit": "2235", "credit": "2236"}, "773": {"debit": "2237", "credit": "2238"},
    "779": {"debit": "2239", "credit": "2240"}, "78": {"debit": "2245", "credit": "2246"}, "781": {"debit": "2247", "credit": "2248"},
    "782": {"debit": "2249", "credit": "2250"}, "783": {"debit": "2251", "credit": "2252"}, "788": {"debit": "2253", "credit": "2254"},
    "1061": {"debit": "2261", "credit": "2262"}, "10611": {"debit": "2263", "credit": "2264"}, "10612": {"debit": "2265", "credit": "2266"},
    "10613": {"debit": "2267", "credit": "2268"}, "10614": {"debit": "2269", "credit": "2270"}, "106141": {"debit": "2271", "credit": "2272"},
    "106142": {"debit": "2273", "credit": "2274"}, "106143": {"debit": "2275", "credit": "2276"}, "106144": {"debit": "2277", "credit": "2278"},
    "106145": {"debit": "2279", "credit": "2280"}, "106148": {"debit": "2281", "credit": "2282"}, "10615": {"debit": "2283", "credit": "2284"},
    "106151": {"debit": "2285", "credit": "2286"}, "106152": {"debit": "2287", "credit": "2288"}, "106153": {"debit": "2289", "credit": "2290"},
    "106154": {"debit": "2291", "credit": "2292"}, "106158": {"debit": "2293", "credit": "2294"}, "10616": {"debit": "2295", "credit": "2296"},
    "106161": {"debit": "2297", "credit": "2298"}, "106162": {"debit": "2299", "credit": "2300"}, "106163": {"debit": "2301", "credit": "2302"},
    "106164": {"debit": "2303", "credit": "2304"}, "106165": {"debit": "2305", "credit": "2306"}, "106166": {"debit": "2307", "credit": "2308"},
    "106168": {"debit": "2309", "credit": "2310"}, "10617": {"debit": "2311", "credit": "2312"}, "106171": {"debit": "2313", "credit": "2314"},
    "106172": {"debit": "2315", "credit": "2316"}, "106173": {"debit": "2317", "credit": "2318"}, "106174": {"debit": "2319", "credit": "2320"},
    "106178": {"debit": "2321", "credit": "2322"}, "10618": {"debit": "2323", "credit": "2324"}, "106181": {"debit": "2325", "credit": "2326"},
    "106183": {"debit": "2329", "credit": "2330"}, "106188": {"debit": "2331", "credit": "2332"}, "10619": {"debit": "2333", "credit": "2334"},
    "106191": {"debit": "2335", "credit": "2336"}, "106192": {"debit": "2337", "credit": "2338"}, "106193": {"debit": "2339", "credit": "2340"},
    "106194": {"debit": "2341", "credit": "2342"}, "106195": {"debit": "2343", "credit": "2344"}, "106198": {"debit": "2345", "credit": "2346"},
    "1062": {"debit": "2347", "credit": "2348"}, "10621": {"debit": "2349", "credit": "2350"}, "10622": {"debit": "2351", "credit": "2352"},
    "10623": {"debit": "2353", "credit": "2354"}, "10624": {"debit": "2355", "credit": "2356"}, "106241": {"debit": "2357", "credit": "2358"},
    "106242": {"debit": "2359", "credit": "2360"}, "106243": {"debit": "2361", "credit": "2362"}, "106244": {"debit": "2363", "credit": "2364"},
    "106248": {"debit": "2365", "credit": "2366"}, "10625": {"debit": "2367", "credit": "2368"}, "10626": {"debit": "2369", "credit": "2370"},
    "10627": {"debit": "2371", "credit": "2372"}, "10628": {"debit": "2373", "credit": "2374"}, "106281": {"debit": "2375", "credit": "2376"},
    "106284": {"debit": "2379", "credit": "2380"}, "106288": {"debit": "2381", "credit": "2382"}, "10629": {"debit": "2383", "credit": "2384"},
    "703001": {"debit": "1875", "credit": "1876"},
    "5130": {"debit": "2533", "credit": "2536"}
}
