import requests
import werkzeug

from odoo.addons.web_unsplash.controllers import main
from odoo import http
from odoo.exceptions import AccessError
from odoo.http import request
from werkzeug.urls import url_encode

# ID of the unsplash collection, used as a fallback for knowledge covers when we can't find a suitable image
UNSPLASH_COLLECTION_ID = 317099

class KnowledgeUnsplash(main.Web_Unsplash):

    @http.route('/knowledge/article/<model("knowledge.article"):article>/add_random_cover', type='json', auth='user')
    def add_random_cover(self, article, **kwargs):
        """ This route will try to fetch a random image from unsplash using the
        params in kwargs. If successful, the image will be saved as a knowledge
        cover, and added as cover of the article given in the params.
        """

        try:
            article.check_access_rights('write')
            article.check_access_rule('write')
        except AccessError:
            raise werkzeug.exceptions.Forbidden()

        # Fetch a random image
        access_key = request.env['ir.config_parameter'].sudo().get_param('unsplash.access_key')
        app_id = self.get_unsplash_app_id()
        # Return errors so that client knows it needs to open the CoverSelector
        # Associated values could be used in the future to adapt client behaviour wr to the error
        if not access_key or not app_id:
            return {'error': 'key_not_found'}
        kwargs['client_id'] = access_key

        has_query = kwargs.get('query', False)
        if has_query:
            try:
                fetch_random_image_request = requests.get('https://api.unsplash.com/photos/random', params=url_encode(kwargs), timeout=5)
            except requests.exceptions.RequestException:
                return {'error': 'request_failed'}
        # If no image matched the query term, do a generic search
        if not has_query or not fetch_random_image_request.ok:
            kwargs.pop('query', None)
            kwargs['collections'] = UNSPLASH_COLLECTION_ID
            try:
                fetch_random_image_request = requests.get('https://api.unsplash.com/photos/random', params=url_encode(kwargs), timeout=5)
            except requests.exceptions.RequestException:
                return {'error': 'request_failed'}
            if not fetch_random_image_request.ok:
                return {'error': fetch_random_image_request.status_code}

        image_info = fetch_random_image_request.json()

        # Save image
        attachment = self.save_unsplash_url({
            image_info['id']: {
                'url': image_info['urls']['regular'],
                'download_url': image_info['links']['download_location'],
                'description': image_info['alt_description'],
            }
        }, res_model='knowledge.cover', **kwargs)[0]

        # Create new cover using new attachment
        cover = request.env['knowledge.cover'].create({'attachment_id': attachment['id']})
        return {'cover_id': cover['id']}
