/** @odoo-module **/

import { registry } from "@web/core/registry";

import { listView } from "@web/views/list/list_view";
import { DocumentsListController } from "./documents_list_controller";
import { DocumentsListModel } from "./documents_list_model";
import { DocumentsListRenderer } from "./documents_list_renderer";
import { DocumentsSearchModel } from "../search/documents_search_model";
import { DocumentsSearchPanel } from "../search/documents_search_panel";

import { device } from "web.config";

const buttonTemplate = device.isMobile
    ? "documents.DocumentsViews.ControlPanelMobile"
    : "documents.DocumentsViews.ControlPanel";

export const DocumentsListView = Object.assign({}, listView, {
    SearchModel: DocumentsSearchModel,
    SearchPanel: DocumentsSearchPanel,
    Controller: DocumentsListController,
    Model: DocumentsListModel,
    Renderer: DocumentsListRenderer,
    searchMenuTypes: ["filter", "groupBy", "favorite"],
    buttonTemplate: buttonTemplate,
});

registry.category("views").add("documents_list", DocumentsListView);
