﻿Imports System.Speech.Synthesis
Imports Microsoft.CognitiveServices.Speech
Imports Microsoft.CognitiveServices.Speech.Audio


Public Class Form1

    Private WithEvents synth As Speech.Synthesis.SpeechSynthesizer
    Private FrmO_azureConfig As SpeechConfig
    Private FrmV_isInitialized As Boolean = False
    Private FrmV_isSpeaking As Boolean = False

    ' Azure Configuration
    Private Const FrmV_AZURE_KEY As String = "please copy the azure key here "
    Private Const FrmV_AZURE_REGION As String = "westeurope"

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Try

            synth = New Speech.Synthesis.SpeechSynthesizer()
            synth.Volume = 100
            synth.Rate = 0


            FrmO_azureConfig = SpeechConfig.FromSubscription(FrmV_AZURE_KEY, FrmV_AZURE_REGION)

            LoadVoices()

            Trk_Volume.Minimum = 0
            Trk_Volume.Maximum = 100
            Trk_Volume.Value = 100
            Lbl_Volume.Text = "الصوت / Volume: 100%"

            Trk_Speed.Minimum = -10
            Trk_Speed.Maximum = 10
            Trk_Speed.Value = 0
            Lbl_Speed.Text = "السرعة / Speed: Normal (0)"

            Lbl_Status.Text = "الحالة: جاهز / Status: Ready"
            FrmV_isInitialized = True

        Catch ex As Exception
            MessageBox.Show("خطأ في التهيئة: " & ex.Message & vbCrLf &
                          "Initialization error: " & ex.Message,
                          "Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Btn_Speak.Enabled = False
        End Try
    End Sub

    Private Sub LoadVoices()
        Cmb_Voice.Items.Clear()


        For Each v As InstalledVoice In synth.GetInstalledVoices()
            If v.VoiceInfo.Culture.TwoLetterISOLanguageName = "en" Then
                Cmb_Voice.Items.Add("🇬🇧 " & v.VoiceInfo.Name & " [Offline]")
            End If
        Next


        Cmb_Voice.Items.Add("🇰🇼 Kuwaiti Arabic - Fahed (Male) [Azure]")
        Cmb_Voice.Items.Add("🇰🇼 Kuwaiti Arabic - Noura (Female) [Azure]")
        Cmb_Voice.Items.Add("🇸🇦 Saudi Arabic - Hamed (Male) [Azure]")
        Cmb_Voice.Items.Add("🇸🇦 Saudi Arabic - Zariyah (Female) [Azure]")
        Cmb_Voice.Items.Add("🇪🇬 Egyptian Arabic - Shakir (Male) [Azure]")
        Cmb_Voice.Items.Add("🇪🇬 Egyptian Arabic - Salma (Female) [Azure]")
        Cmb_Voice.Items.Add("🇦🇪 UAE Arabic - Fatima (Female) [Azure]")
        Cmb_Voice.Items.Add("🇦🇪 UAE Arabic - Hamdan (Male) [Azure]")

        If Cmb_Voice.Items.Count > 0 Then
            Cmb_Voice.SelectedIndex = 0
        End If
    End Sub


    Private Function GetAzureVoiceName(selectedVoice As String) As String

        If selectedVoice.Contains("Fahed") Then
            Return "ar-KW-FahedNeural"
        ElseIf selectedVoice.Contains("Noura") Then
            Return "ar-KW-NouraNeural"
        ElseIf selectedVoice.Contains("Hamed") Then
            Return "ar-SA-HamedNeural"
        ElseIf selectedVoice.Contains("Zariyah") Then
            Return "ar-SA-ZariyahNeural"
        ElseIf selectedVoice.Contains("Shakir") Then
            Return "ar-EG-ShakirNeural"
        ElseIf selectedVoice.Contains("Salma") Then
            Return "ar-EG-SalmaNeural"
        ElseIf selectedVoice.Contains("Fatima") Then
            Return "ar-AE-FatimaNeural"
        ElseIf selectedVoice.Contains("Hamdan") Then
            Return "ar-AE-HamdanNeural"
        Else
            Return "ar-KW-FahedNeural"
        End If
    End Function


    Private Async Sub btnSpeak_Click(sender As Object, e As EventArgs) Handles Btn_Speak.Click
        If Not FrmV_isInitialized OrElse FrmV_isSpeaking Then Return

        Dim text As String = Txt_Input.Text.Trim()
        If text = "" Then
            MessageBox.Show("الرجاء إدخال نص" & vbCrLf & "Please enter text",
                          "تنبيه / Alert", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Return
        End If

        Dim selectedVoice As String = If(Cmb_Voice.SelectedItem IsNot Nothing,
                                         Cmb_Voice.SelectedItem.ToString(), "")

        If selectedVoice.Contains("[Azure]") Then
            Await SpeakWithAzure(text, selectedVoice)
        Else
            SpeakWithSAPI(text)
        End If
    End Sub

    Private Sub SpeakWithSAPI(text As String)
        Try
            FrmV_isSpeaking = True
            Btn_Speak.Enabled = False
            Lbl_Status.Text = "Status: Speaking (English - Offline)"

            synth.Volume = Trk_Volume.Value
            synth.Rate = Trk_Speed.Value

            Dim voiceName As String = Cmb_Voice.SelectedItem.ToString()
            voiceName = voiceName.Replace("🇬🇧 ", "").Replace(" [Offline]", "")
            synth.SelectVoice(voiceName)
            synth.SpeakAsync(text)

        Catch ex As Exception
            MessageBox.Show("English TTS error: " & ex.Message)
            ResetUI()
        End Try
    End Sub


    Private Async Function SpeakWithAzure(text As String, selectedVoice As String) As Task
        Try
            FrmV_isSpeaking = True
            Btn_Speak.Enabled = False
            Btn_Stop.Enabled = True
            Lbl_Status.Text = "الحالة: جاري النطق... / Status: Speaking (Azure)..."

            If FrmV_AZURE_KEY = "YOUR_AZURE_KEY_HERE" Then
                MessageBox.Show("Azure Speech Service not configured!" & vbCrLf & vbCrLf &
                              "Please set your Azure subscription key in the code." & vbCrLf & vbCrLf &
                              "Get free key at: https://portal.azure.com",
                              "Configuration Error", MessageBoxButtons.OK, MessageBoxIcon.Warning)
                ResetUI()
                Return
            End If

            Dim voiceName As String = GetAzureVoiceName(selectedVoice)

            Dim speedPercent As Integer = Trk_Speed.Value * 10
            Dim speedStr As String = If(speedPercent >= 0, "+" & speedPercent, speedPercent.ToString()) & "%"

            Dim ssml As String = $"<speak version='1.0' xmlns='http://www.w3.org/2001/10/synthesis' xml:lang='ar-SA'>
    <voice name='{voiceName}'>
        <prosody rate='{speedStr}' volume='{Trk_Volume.Value}'>
            {System.Security.SecurityElement.Escape(text)}
        </prosody>
    </voice>
</speak>"


            Using audioCfg = AudioConfig.FromDefaultSpeakerOutput()
                Using azureSynthesizer As New Microsoft.CognitiveServices.Speech.SpeechSynthesizer(FrmO_azureConfig, audioCfg)



                    Dim result = Await azureSynthesizer.SpeakSsmlAsync(ssml)


                    If result.Reason = ResultReason.SynthesizingAudioCompleted Then

                    ElseIf result.Reason = ResultReason.Canceled Then
                        Dim cancellation = SpeechSynthesisCancellationDetails.FromResult(result)
                        MessageBox.Show($"فشل النطق / Speech failed:" & vbCrLf &
                                      $"Error: {cancellation.ErrorDetails}" & vbCrLf &
                                      $"Reason: {cancellation.Reason}",
                                      "خطأ / Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
                    End If

                End Using
            End Using

        Catch ex As Exception
            MessageBox.Show("فشل النطق العربي: " & ex.Message & vbCrLf &
                          "Arabic TTS failed: " & ex.Message,
                          "خطأ / Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
        Finally
            ResetUI()
        End Try
    End Function


    Private Sub btnStop_Click(sender As Object, e As EventArgs) Handles Btn_Stop.Click
        Try

            synth.SpeakAsyncCancelAll()

            ResetUI()
        Catch ex As Exception
            ResetUI()
        End Try
    End Sub

    Private Sub ResetUI()
        FrmV_isSpeaking = False
        Btn_Speak.Enabled = True
        Btn_Stop.Enabled = True
        Lbl_Status.Text = "الحالة: جاهز / Status: Ready"
    End Sub

    Private Sub trackVolume_Scroll(sender As Object, e As EventArgs) Handles Trk_Volume.Scroll
        Lbl_Volume.Text = "الصوت / Volume: " & Trk_Volume.Value & "%"
    End Sub

    Private Sub trackSpeed_Scroll(sender As Object, e As EventArgs) Handles Trk_Speed.Scroll
        Dim speedText As String = If(Trk_Speed.Value = 0, "عادي / Normal",
                                     If(Trk_Speed.Value > 0, "أسرع / Fast", "أبطأ / Slow"))
        Lbl_Speed.Text = "السرعة / Speed: " & speedText & " (" & Trk_Speed.Value & ")"
    End Sub

    Private Sub synth_SpeakCompleted(sender As Object, e As SpeakCompletedEventArgs) Handles synth.SpeakCompleted
        ResetUI()
    End Sub

    Private Sub Form1_FormClosing(sender As Object, e As FormClosingEventArgs) Handles MyBase.FormClosing
        If synth IsNot Nothing Then synth.Dispose()
    End Sub




End Class