﻿Imports System.Runtime.InteropServices
Imports System.Drawing
Imports System.Windows.Forms

Public Class Form1
    ' WinAPI Functions
    <DllImport("user32.dll", SetLastError:=True)>
    Private Shared Function EnumWindows(ByVal lpEnumFunc As EnumWindowsProc, ByVal lParam As IntPtr) As Boolean
    End Function

    Private Delegate Function EnumWindowsProc(ByVal hWnd As IntPtr, ByVal lParam As IntPtr) As Boolean

    <DllImport("user32.dll", SetLastError:=True)>
    Private Shared Function GetWindowText(ByVal hWnd As IntPtr, ByVal lpString As System.Text.StringBuilder, ByVal nMaxCount As Integer) As Integer
    End Function

    <DllImport("user32.dll", SetLastError:=True)>
    Private Shared Function IsWindowVisible(ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll", SetLastError:=True)>
    Private Shared Function SetForegroundWindow(ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll", SetLastError:=True)>
    Private Shared Function PostMessage(ByVal hWnd As IntPtr, ByVal msg As Integer, ByVal wParam As IntPtr, ByVal lParam As IntPtr) As Boolean
    End Function

    ' Constants for Closing Windows
    Private Const WM_CLOSE As Integer = &H10

    ' Icon retrieval functions
    Private Const GCL_HICON As Integer = -14
    Private Const GCL_HICONSM As Integer = -34

    <DllImport("user32.dll", SetLastError:=True, EntryPoint:="GetClassLong")>
    Private Shared Function GetClassLong32(ByVal hWnd As IntPtr, ByVal nIndex As Integer) As IntPtr
    End Function

    <DllImport("user32.dll", SetLastError:=True, EntryPoint:="GetClassLongPtr")>
    Private Shared Function GetClassLong64(ByVal hWnd As IntPtr, ByVal nIndex As Integer) As IntPtr
    End Function

    Private Shared Function GetClassLongPtr(ByVal hWnd As IntPtr, ByVal nIndex As Integer) As IntPtr
        If IntPtr.Size = 4 Then
            Return GetClassLong32(hWnd, nIndex) ' 32-bit
        Else
            Return GetClassLong64(hWnd, nIndex) ' 64-bit
        End If
    End Function

    <DllImport("user32.dll", SetLastError:=True)>
    Private Shared Function DestroyIcon(ByVal hIcon As IntPtr) As Boolean
    End Function

    ' UI Components
    Private WithEvents lstTaskbarContents As New ListView()
    Private WithEvents txtSearch As New TextBox()
    Private WithEvents btnRefresh As New Button()
    Private WithEvents btnSelect As New Button()
    Private WithEvents btnClose As New Button()
    Private imageList As New ImageList()

    ' Dictionary to store window handles
    Private windowHandles As New Dictionary(Of String, IntPtr)
    Private allItems As New List(Of ListViewItem)() ' Store all items for filtering

    ' Form Constructor
    Public Sub New()
        ' Form Properties
        Me.Text = "Taskbar Manager"
        Me.Size = New Size(500, 500)

        ' Configure Search Box
        txtSearch.Dock = DockStyle.Top
        txtSearch.Text = "Search..."
        AddHandler txtSearch.TextChanged, AddressOf FilterTaskbarContents
        Me.Controls.Add(txtSearch)

        ' Configure ListView
        lstTaskbarContents.View = View.Details
        lstTaskbarContents.Columns.Add("Window", 350)
        lstTaskbarContents.SmallImageList = imageList
        lstTaskbarContents.Dock = DockStyle.Top
        lstTaskbarContents.Height = 300
        Me.Controls.Add(lstTaskbarContents)

        ' Configure Buttons
        btnRefresh.Text = "Refresh List"
        btnRefresh.Dock = DockStyle.Top
        AddHandler btnRefresh.Click, AddressOf UpdateTaskbarContents
        Me.Controls.Add(btnRefresh)

        btnSelect.Text = "Activate Window"
        btnSelect.Dock = DockStyle.Top
        AddHandler btnSelect.Click, AddressOf ActivateSelectedWindow
        Me.Controls.Add(btnSelect)

        btnClose.Text = "Close Selected"
        btnClose.Dock = DockStyle.Top
        AddHandler btnClose.Click, AddressOf CloseSelectedWindow
        Me.Controls.Add(btnClose)

        ' Populate the ListView initially
        UpdateTaskbarContents()
    End Sub

    ' Get Taskbar Applications
    Private Sub UpdateTaskbarContents()
        lstTaskbarContents.Items.Clear()
        windowHandles.Clear()
        imageList.Images.Clear()
        allItems.Clear()

        EnumWindows(AddressOf EnumWindowsCallback, IntPtr.Zero)
    End Sub

    ' Callback to Get Visible Windows
    Private Function EnumWindowsCallback(ByVal hWnd As IntPtr, ByVal lParam As IntPtr) As Boolean
        If IsWindowVisible(hWnd) Then
            Dim title As New System.Text.StringBuilder(256)
            GetWindowText(hWnd, title, title.Capacity)
            Dim windowTitle As String = title.ToString().Trim()

            If Not String.IsNullOrEmpty(windowTitle) Then
                Dim icon As Icon = GetWindowIcon(hWnd)
                If icon IsNot Nothing Then
                    imageList.Images.Add(windowTitle, icon)
                End If

                Dim item As New ListViewItem(windowTitle)
                If imageList.Images.ContainsKey(windowTitle) Then
                    item.ImageKey = windowTitle
                End If

                lstTaskbarContents.Items.Add(item)
                allItems.Add(item)
                windowHandles(windowTitle) = hWnd ' Store handle
            End If
        End If
        Return True
    End Function

    ' Get Window Icon
    Private Function GetWindowIcon(ByVal hWnd As IntPtr) As Icon
        Dim hIcon As IntPtr = GetClassLongPtr(hWnd, GCL_HICON)
        If hIcon = IntPtr.Zero Then
            hIcon = GetClassLongPtr(hWnd, GCL_HICONSM)
        End If

        If hIcon <> IntPtr.Zero Then
            Dim icon As Icon = Icon.FromHandle(hIcon)
            Dim newIcon As Icon = CType(icon.Clone(), Icon)
            DestroyIcon(hIcon)
            Return newIcon
        End If

        Return Nothing
    End Function

    ' Activate Window
    Private Sub ActivateSelectedWindow(sender As Object, e As EventArgs)
        If lstTaskbarContents.SelectedItems.Count > 0 Then
            Dim selectedWindow As String = lstTaskbarContents.SelectedItems(0).Text
            If windowHandles.ContainsKey(selectedWindow) Then
                SetForegroundWindow(windowHandles(selectedWindow))
            End If
        Else
            MessageBox.Show("Please select a window to activate.")
        End If
    End Sub

    ' Close Window
    Private Sub CloseSelectedWindow(sender As Object, e As EventArgs)
        If lstTaskbarContents.SelectedItems.Count > 0 Then
            Dim selectedWindow As String = lstTaskbarContents.SelectedItems(0).Text
            If windowHandles.ContainsKey(selectedWindow) Then
                PostMessage(windowHandles(selectedWindow), WM_CLOSE, IntPtr.Zero, IntPtr.Zero)
            End If
        Else
            MessageBox.Show("Please select a window to close.")
        End If
    End Sub

    ' Search Filter
    Private Sub FilterTaskbarContents(sender As Object, e As EventArgs)
        Dim searchText As String = txtSearch.Text.ToLower()
        lstTaskbarContents.Items.Clear()

        For Each item As ListViewItem In allItems
            If item.Text.ToLower().Contains(searchText) Then
                lstTaskbarContents.Items.Add(item)
            End If
        Next
    End Sub

    ' Main entry point
    <STAThread>
    Public Shared Sub Main()
        Application.EnableVisualStyles()
        Application.Run(New Form1())
    End Sub
End Class
