﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="Viewer.aspx.vb" Inherits="Indexedsearching.Viewer" %>
<!DOCTYPE html>
<html>
<head runat="server">
    <title>TIFF Viewer</title>
    <style>
        body {
            font-family: "Segoe UI", Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #2c3e50;
        }

        .viewer-container {
            max-width: 100%;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .header {
            background-color: #1a252f;
            color: white;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.3);
        }

        .header-left {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .file-name {
            font-size: 18px;
            font-weight: 600;
        }

        .page-info {
            font-size: 14px;
            color: #95a5a6;
        }

        .btn-back {
            background-color: #0078d7;
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 4px;
            text-decoration: none;
            cursor: pointer;
            font-size: 14px;
        }

        .btn-back:hover {
            background-color: #005fa3;
        }

        .navigation-bar {
            background-color: #34495e;
            padding: 15px 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 15px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.2);
        }

        .nav-button {
            background-color: #0078d7;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: background-color 0.2s;
        }

        .nav-button:hover:not(:disabled) {
            background-color: #005fa3;
        }

        .nav-button:disabled {
            background-color: #7f8c8d;
            cursor: not-allowed;
            opacity: 0.5;
        }

        .page-input {
            width: 80px;
            padding: 8px;
            text-align: center;
            border: 2px solid #0078d7;
            border-radius: 4px;
            font-size: 14px;
        }

        .zoom-controls {
            display: flex;
            gap: 10px;
            align-items: center;
        }

        .zoom-button {
            background-color: #27ae60;
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }

        .zoom-button:hover {
            background-color: #229954;
        }

        .zoom-label {
            color: white;
            font-size: 14px;
            min-width: 60px;
            text-align: center;
        }

        .content-area {
            flex: 1;
            overflow: auto;
            background-color: #2c3e50;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            padding: 20px;
        }

        .image-container {
            background-color: white;
            padding: 10px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.5);
            border-radius: 4px;
            max-width: 100%;
        }

        .tiff-image {
            display: block;
            max-width: 100%;
            height: auto;
            transition: transform 0.2s;
        }

        .error-message {
            background-color: #e74c3c;
            color: white;
            padding: 20px;
            border-radius: 4px;
            margin: 20px;
            text-align: center;
        }

        .loading {
            color: white;
            text-align: center;
            padding: 40px;
            font-size: 18px;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <div class="viewer-container">
            <!-- Header -->
            <div class="header">
                <div class="header-left">
                    <asp:HyperLink ID="lnkBack" runat="server" NavigateUrl="~/Search.aspx" CssClass="btn-back">
                        ← Back to Search
                    </asp:HyperLink>
                    <div>
                        <div class="file-name">
                            <asp:Label ID="lblFileName" runat="server"></asp:Label>
                        </div>
                        <div class="page-info">
                            <asp:Label ID="lblPageInfo" runat="server"></asp:Label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Navigation Bar -->
            <asp:Panel ID="pnlNavigation" runat="server" CssClass="navigation-bar" Visible="false">
                <asp:Button ID="btnFirst" runat="server" Text="⏮ First" CssClass="nav-button" OnClick="btnFirst_Click" />
                <asp:Button ID="btnPrevious" runat="server" Text="◀ Previous" CssClass="nav-button" OnClick="btnPrevious_Click" />
                
                <span style="color: white;">Page:</span>
                <asp:TextBox ID="txtPageNumber" runat="server" CssClass="page-input" AutoPostBack="true" OnTextChanged="txtPageNumber_TextChanged"></asp:TextBox>
                <span style="color: white;">of <asp:Label ID="lblTotalPages" runat="server"></asp:Label></span>
                
                <asp:Button ID="btnNext" runat="server" Text="Next ▶" CssClass="nav-button" OnClick="btnNext_Click" />
                <asp:Button ID="btnLast" runat="server" Text="Last ⏭" CssClass="nav-button" OnClick="btnLast_Click" />

                <div style="border-left: 2px solid #7f8c8d; height: 30px; margin: 0 10px;"></div>

                <div class="zoom-controls">
                    <asp:Button ID="btnZoomOut" runat="server" Text="−" CssClass="zoom-button" OnClick="btnZoomOut_Click" />
                    <span class="zoom-label"><asp:Label ID="lblZoom" runat="server" Text="100%"></asp:Label></span>
                    <asp:Button ID="btnZoomIn" runat="server" Text="+" CssClass="zoom-button" OnClick="btnZoomIn_Click" />
                    <asp:Button ID="btnZoomReset" runat="server" Text="Reset" CssClass="zoom-button" OnClick="btnZoomReset_Click" />
                </div>
            </asp:Panel>

            <!-- Content Area -->
            <div class="content-area">
                <asp:Panel ID="pnlError" runat="server" Visible="false">
                    <div class="error-message">
                        <asp:Label ID="lblError" runat="server"></asp:Label>
                    </div>
                </asp:Panel>

                <asp:Panel ID="pnlImage" runat="server" Visible="false">
                    <div class="image-container">
                        <asp:Image ID="imgViewer" runat="server" CssClass="tiff-image" />
                    </div>
                </asp:Panel>
            </div>
        </div>
    </form>
</body>
</html>