﻿Imports System.IO

Public Class Search
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            lblSourcePath.Text = LuceneSearch.ALLOWED_ROOT
            CheckIndexStatus()
        End If
    End Sub

    Private Sub CheckIndexStatus()
        If Directory.Exists(LuceneSearch.INDEX_PATH) AndAlso Directory.GetFiles(LuceneSearch.INDEX_PATH).Length > 0 Then
            lblIndexStatus.Text = "<div class='status-message status-success'>Index is ready</div>"
        Else
            lblIndexStatus.Text = "<div class='status-message status-warning'>No index found. Please build index first.</div>"
        End If
    End Sub

    Protected Sub btnBuildIndex_Click(sender As Object, e As EventArgs)
        Try

            If Not Directory.Exists(LuceneSearch.INDEX_PATH) Then
                Directory.CreateDirectory(LuceneSearch.INDEX_PATH)
            End If


            If Not Directory.Exists(LuceneSearch.ALLOWED_ROOT) Then
                Directory.CreateDirectory(LuceneSearch.ALLOWED_ROOT)
                lblIndexStatus.Text = "<div class='status-message status-warning'>" &
                    "Source folder created at: " & LuceneSearch.ALLOWED_ROOT & "<br/>" &
                    "Please add .txt or .docx files to this folder and click 'Build Index' again." &
                    "</div>"
                Return
            End If


            Dim files = Directory.GetFiles(LuceneSearch.ALLOWED_ROOT, "*.*").Where(Function(f) _
                Path.GetExtension(f).ToLower() = ".txt" OrElse
                Path.GetExtension(f).ToLower() = ".docx" OrElse
                Path.GetExtension(f).ToLower() = ".tif" OrElse
                Path.GetExtension(f).ToLower() = ".tiff").ToArray()

            If files.Length = 0 Then
                lblIndexStatus.Text = "<div class='status-message status-warning'>" &
                    "No .txt, .docx, or .tiff files found in: " & LuceneSearch.ALLOWED_ROOT &
                    "</div>"
                Return
            End If


            LuceneSearch.BuildIndex(LuceneSearch.ALLOWED_ROOT)

            lblIndexStatus.Text = "<div class='status-message status-success'>" &
                "Index built successfully! Indexed " & files.Length & " file(s)." &
                "</div>"

        Catch ex As Exception
            lblIndexStatus.Text = "<div class='status-message status-error'>" &
                "Error building index: " & ex.Message &
                "</div>"
        End Try
    End Sub

    Protected Sub btnSearch_Click(sender As Object, e As EventArgs)
        Try

            If Not Directory.Exists(LuceneSearch.INDEX_PATH) OrElse Directory.GetFiles(LuceneSearch.INDEX_PATH).Length = 0 Then
                lblIndexStatus.Text = "<div class='status-message status-error'>" &
                    "Index not found. Please click 'Build Index' first." &
                    "</div>"
                gvResults.DataSource = Nothing
                gvResults.DataBind()
                Return
            End If


            If String.IsNullOrWhiteSpace(txtMust.Text) AndAlso String.IsNullOrWhiteSpace(txtOr.Text) Then
                lblIndexStatus.Text = "<div class='status-message status-warning'>" &
                    "Please enter at least one search term in 'Must contain' or 'May contain'." &
                    "</div>"
                Return
            End If


            Dim dt = LuceneSearch.Search(txtMust.Text, txtOr.Text, txtNot.Text, 200)
            gvResults.DataSource = dt
            gvResults.DataBind()

            lblIndexStatus.Text = "<div class='status-message status-success'>" &
                "Found " & dt.Rows.Count & " result(s)." &
                "</div>"

        Catch ex As Exception
            lblIndexStatus.Text = "<div class='status-message status-error'>" &
                "Search error: " & ex.Message &
                "</div>"
        End Try
    End Sub

    Protected Sub gvResults_RowCommand(sender As Object, e As GridViewCommandEventArgs)
        If e.CommandName = "ViewFile" Then
            Try

                Dim filePath As String = e.CommandArgument.ToString()


                System.Diagnostics.Debug.WriteLine("File path from CommandArgument: " & filePath)


                If String.IsNullOrEmpty(filePath) Then
                    lblIndexStatus.Text = "<div class='status-message status-error'>" &
                        "Invalid file path." &
                        "</div>"
                    Return
                End If


                If Not File.Exists(filePath) Then
                    lblIndexStatus.Text = "<div class='status-message status-error'>" &
                        "File not found: " & filePath &
                        "</div>"
                    Return
                End If


                Response.Redirect("Viewer.aspx?file=" & Server.UrlEncode(filePath) & "&page=0")

            Catch ex As Exception
                lblIndexStatus.Text = "<div class='status-message status-error'>" &
                    "Error opening file: " & ex.Message & "<br/>Stack: " & ex.StackTrace &
                    "</div>"
            End Try
        End If
    End Sub
End Class